/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import stream.annotations.Description;
import stream.data.Data;
import stream.statistics.StatisticsLearner;

@Description(group="Data Stream.Processing.Statistics", text="Continuously determines the minimum values for numeric attributes")
public class Minima
extends StatisticsLearner {
    @Override
    public void updateStatistics(Data item) {
        if (this.keys == null) {
            return;
        }
        for (String key : this.keys) {
            Double val = null;
            try {
                val = new Double(item.get(key) + "");
            }
            catch (Exception e) {
                val = null;
            }
            Double cur = (Double)this.statistics.get(key);
            if (val == null) continue;
            if (cur == null) {
                this.statistics.put(key, val);
            } else {
                this.statistics.put(key, Math.max(cur, val));
            }
            if (this.prefix != null) {
                item.put(this.prefix + key, this.statistics.get(key));
                continue;
            }
            item.put(key, this.statistics.get(key));
        }
    }
}

