/*
 * Decompiled with CFR 0.152.
 */
package stream.storm;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.data.Data;
import stream.data.DataFactory;

public class ClockSpout
extends BaseRichSpout {
    private static final long serialVersionUID = 812144742121538026L;
    static Logger log = LoggerFactory.getLogger(ClockSpout.class);
    Long interval = 1000L;
    SpoutOutputCollector output;

    public ClockSpout(Long interval) {
        this.interval = interval;
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.output = collector;
    }

    public void nextTuple() {
        block2: {
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception e) {
                log.error("Error while taking my interval-nap: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
        Data item = DataFactory.create();
        item.put("@time", System.currentTimeMillis());
        this.output.emit((List)new Values(new Object[]{item}));
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        log.debug("Declaring output-field 'stream.Data'");
        declarer.declare(new Fields(new String[]{"stream.Data"}));
    }
}

