/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class MultiSet<T>
implements Set<T> {
    final Map<T, AtomicLong> countMap = new LinkedHashMap<T, AtomicLong>();

    @Override
    public boolean add(T arg0) {
        if (this.countMap.containsKey(arg0)) {
            this.countMap.get(arg0).incrementAndGet();
            return true;
        }
        this.countMap.put(arg0, new AtomicLong(1L));
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        boolean added = false;
        for (T obj : arg0) {
            added = this.add(obj) | added;
        }
        return added;
    }

    @Override
    public void clear() {
        this.countMap.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.countMap.containsKey(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        for (Object o : arg0) {
            if (this.countMap.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.countMap.keySet().iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        if (this.countMap.containsKey(arg0)) {
            long cnt = this.countMap.get(arg0).decrementAndGet();
            if (cnt < 1L) {
                this.countMap.remove(arg0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        boolean removed = false;
        for (Object o : arg0) {
            removed = this.remove(o) | removed;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        boolean removed = false;
        Iterator<T> it = this.countMap.keySet().iterator();
        while (it.hasNext()) {
            T obj = it.next();
            if (arg0.contains(obj)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public int size() {
        return this.countMap.size();
    }

    @Override
    public Object[] toArray() {
        int i = 0;
        Object[] result = new Object[this.countMap.size()];
        for (T obj : this.countMap.keySet()) {
            result[i] = obj;
            ++i;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        Iterator<T> it = this.countMap.keySet().iterator();
        for (int i = 0; i < arg0.length && i < this.countMap.size(); ++i) {
            T obj = it.next();
            arg0[i] = obj;
        }
        return arg0;
    }
}

