/*
 * Decompiled with CFR 0.152.
 */
package stream;

import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;
import stream.expressions.Expression;
import stream.expressions.ExpressionCompiler;

public abstract class ConditionedProcessor
extends AbstractProcessor {
    Expression condition;

    public String getCondition() {
        if (this.condition == null) {
            return "";
        }
        return this.condition.toString();
    }

    @Parameter(name="condition", required=false, description="The condition parameter allows to specify a boolean expression that is matched against each item. The processor only processes items matching that expression.")
    public void setCondition(String condition) {
        try {
            if (condition == null || "".equals(condition.trim())) {
                condition = null;
                return;
            }
            this.condition = ExpressionCompiler.parse(condition);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean matches(Data item) {
        return this.condition == null || this.condition.matches(this.context, item);
    }

    @Override
    public Data process(Data data) {
        if (this.matches(data)) {
            return this.processMatchingData(data);
        }
        return data;
    }

    public abstract Data processMatchingData(Data var1);
}

