/*
 * Decompiled with CFR 0.152.
 */
package stream;

import java.util.ArrayList;
import java.util.List;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.Processor;
import stream.StatefulProcessor;
import stream.annotations.Internal;

@Internal
public class ProcessorList
extends AbstractProcessor {
    protected final List<Processor> processors = new ArrayList<Processor>();

    @Override
    public Data process(Data input) {
        Data data = input;
        if (data != null) {
            for (Processor p : this.processors) {
                data = p.process(data);
                if (data != null) continue;
                return null;
            }
            return data;
        }
        return input;
    }

    @Override
    public void init(ProcessContext context) throws Exception {
        super.init(context);
        this.context = context;
        for (Processor p : this.processors) {
            if (!(p instanceof StatefulProcessor)) continue;
            ((StatefulProcessor)p).init(context);
        }
    }

    @Override
    public void finish() throws Exception {
        for (Processor p : this.processors) {
            if (!(p instanceof StatefulProcessor)) continue;
            ((StatefulProcessor)p).finish();
        }
    }

    public void addProcessor(Processor p) {
        this.processors.add(p);
    }

    public void addProcessor(int idx, Processor p) {
        this.processors.add(idx, p);
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }
}

