/*
 * Decompiled with CFR 0.152.
 */
package stream;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.DocumentEncoder;
import stream.StreamTopology;
import stream.util.XMLUtils;

public class StormRunner {
    static Logger log = LoggerFactory.getLogger(StormRunner.class);
    public static final String UUID_ATTRIBUTE = "stream.storm.uuid";

    public static void addUUIDAttributes(Element element) {
        UUID id = UUID.randomUUID();
        element.setAttribute(UUID_ATTRIBUTE, id.toString());
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            StormRunner.addUUIDAttributes((Element)node);
        }
    }

    public static String createIDs(InputStream in) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        StormRunner.addUUIDAttributes(doc.getDocumentElement());
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter out = new StringWriter();
        StreamResult output = new StreamResult(out);
        trans.transform(source, output);
        String xml = out.toString();
        return xml;
    }

    public static Element findElementByUUID(Element el, String uuid) {
        String id = el.getAttribute(UUID_ATTRIBUTE);
        if (uuid.equals(id)) {
            return el;
        }
        NodeList list = el.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element found;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || (found = StormRunner.findElementByUUID((Element)node, uuid)) == null) continue;
            return found;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        InputStream in = null;
        if (args.length > 0) {
            File xml = new File(args[0]);
            in = new FileInputStream(xml);
        } else {
            in = StormRunner.class.getResourceAsStream("/example.xml");
        }
        long start = System.currentTimeMillis();
        String xml = StormRunner.createIDs(in);
        long end = System.currentTimeMillis();
        log.info("Creating XML took {}", (Object)(end - start));
        log.info("XML result is:\n{}", (Object)xml);
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        doc = XMLUtils.parseDocument(xml);
        doc = XMLUtils.addUUIDAttributes(doc, UUID_ATTRIBUTE);
        log.info("Encoding document...");
        String enc = DocumentEncoder.encodeDocument(doc);
        log.info("Arg will be:\n{}", (Object)enc);
        Document decxml = DocumentEncoder.decodeDocument(enc);
        log.info("Decoded XML is: {}", (Object)XMLUtils.toString(decxml));
        if (enc == null) {
            return;
        }
        Config conf = new Config();
        conf.setDebug(true);
        if (System.getProperty("local") == null) {
            StormSubmitter.submitTopology((String)"test", (Map)conf, (StormTopology)StreamTopology.createTopology(doc));
        } else {
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology("test", (Map)conf, StreamTopology.createTopology(doc));
            log.info("Topology submitted.");
            Utils.sleep((long)10000000L);
            cluster.killTopology("test");
            cluster.shutdown();
        }
    }
}

