/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataImpl;

public class DataFactory {
    static Logger log = LoggerFactory.getLogger(DataFactory.class);
    public static DataFactory defaultDataFactory = new DataFactory();
    private static long dataItemsCreated = 0L;

    protected DataFactory() {
    }

    public static void setDefaultDataFactory(DataFactory factory) throws Exception {
        if (dataItemsCreated > 0L) {
            throw new Exception("Data items have already been created with the current DataFactory '" + defaultDataFactory + "'. The DataFactory cannot be changed anymore!");
        }
        defaultDataFactory = factory;
    }

    public Data createDataItem() {
        return new DataImpl();
    }

    public Data createDataItem(Map<String, Serializable> item) {
        return new DataImpl(item);
    }

    public static Data create() {
        ++dataItemsCreated;
        return defaultDataFactory.createDataItem();
    }

    public static Data create(Map<String, Serializable> data) {
        ++dataItemsCreated;
        return defaultDataFactory.createDataItem(data);
    }

    public static long getDataItemsCreated() {
        return dataItemsCreated;
    }
}

