/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Description;
import stream.annotations.Parameter;

@Description(group="Data Stream.Processing.Transformations.Data", text="")
public class MapValueToID
implements Processor {
    static Logger log = LoggerFactory.getLogger(MapValueToID.class);
    Integer maxId = 0;
    String key = "key";
    Map<String, Integer> mapping = new HashMap<String, Integer>();

    public String getKey() {
        return this.key;
    }

    @Parameter
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Data process(Data data) {
        if (this.key == null) {
            log.error("No key specified!");
            return data;
        }
        Serializable val = (Serializable)data.get(this.key);
        if (val == null) {
            log.debug("No value found in data-item! Skipping that item.");
            return data;
        }
        Integer id = this.mapping.get(val.toString());
        if (id == null) {
            id = 1 + this.maxId;
            Integer n = this.maxId;
            Integer n2 = this.maxId = Integer.valueOf(this.maxId + 1);
            log.debug("Adding new ID {} for value {}", (Object)id, (Object)val);
            this.mapping.put(val.toString(), id);
        } else {
            log.debug("Found existing ID mapping {} => {}", (Object)val, (Object)id);
        }
        this.mapping.put(this.key, id);
        data.put(this.key, id);
        return data;
    }
}

