/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessorList;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.util.WildcardPattern;

public class WithKeys
extends ProcessorList {
    static Logger log = LoggerFactory.getLogger(WithKeys.class);
    String[] keys = null;
    Set<String> selected = new HashSet<String>();
    private Boolean merge = true;

    @Parameter(description="A list of filter keys selecting the attributes that should be provided to the inner processors.")
    public void setKeys(String[] keys) {
        this.keys = keys;
        for (String key : keys) {
            this.selected.add(key);
        }
    }

    public String[] getKeys() {
        return this.keys;
    }

    public Boolean getMerge() {
        return this.merge;
    }

    @Parameter(description="Indicates whether the outcome of the inner processors should be merged into the input data item, defaults to true.")
    public void setMerge(Boolean join) {
        this.merge = join;
    }

    @Override
    public Data process(Data data) {
        Data innerItem = null;
        if (this.keys == null || this.keys.length == 0) {
            innerItem = DataFactory.create();
        } else {
            innerItem = DataFactory.create();
            for (String key : data.keySet()) {
                if (!this.isSelected(key)) continue;
                innerItem.put(key, data.get(key));
            }
            for (String key : this.keys) {
                if (innerItem.containsKey(key)) continue;
                innerItem.remove(key);
            }
        }
        Data processed = super.process(innerItem);
        if (this.merge != null && !this.merge.booleanValue()) {
            return processed;
        }
        if (this.merge == null || this.merge.booleanValue() && processed != null) {
            for (String key : processed.keySet()) {
                data.put(key, processed.get(key));
            }
            Set k = data.keySet();
            Iterator it = k.iterator();
            while (it.hasNext()) {
                String str = (String)it.next();
                if (processed.containsKey(str) || !this.isSelected(str)) continue;
                it.remove();
            }
        }
        return data;
    }

    private boolean isSelected(String key) {
        if (this.keys == null || this.keys.length == 0) {
            return false;
        }
        boolean included = false;
        for (String k : this.keys) {
            if (k.startsWith("!")) {
                k = k.substring(1);
                if (included && WildcardPattern.matches(k, key)) {
                    included = false;
                }
                log.debug("Removing '{}' from selection due to pattern '!{}'", (Object)key, (Object)k);
                continue;
            }
            if (included || !WildcardPattern.matches(k, key)) continue;
            included = true;
            log.debug("Adding '{}' to selection due to pattern '{}'", (Object)key, (Object)k);
        }
        return included;
    }
}

