/*
 * Decompiled with CFR 0.152.
 */
package stream.data.graph;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.graph.GraphService;
import stream.io.CsvStream;

public class GraphProvider
implements GraphService {
    static Logger log = LoggerFactory.getLogger(GraphProvider.class);
    Map<String, Set<String>> neighbors = new HashMap<String, Set<String>>();
    File file;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void reset() throws Exception {
        log.debug("Reading graph from {}", (Object)this.file);
        CsvStream stream = new CsvStream(new FileInputStream(this.file));
        Data item = stream.readNext();
        while (item != null) {
            Serializable start = (Serializable)item.get("start");
            Serializable end = (Serializable)item.get("end");
            if (start == null || end == null) {
                throw new Exception("Failed to extract start/end from data item: " + item + "!");
            }
            this.addEdge(start.toString(), end.toString());
            item = stream.readNext();
        }
        stream.close();
    }

    public void addEdge(String start, String end) {
        Set<String> neighs = this.neighbors.get(start);
        if (neighs == null) {
            neighs = new LinkedHashSet<String>();
            this.neighbors.put(start, neighs);
        }
        neighs.add(end);
        log.debug("Adding edge ({},{})", (Object)start, (Object)end);
        log.debug("Neighbors of {} are: {}", (Object)start, (Object)neighs);
    }

    @Override
    public Set<String> getNodes() {
        return this.neighbors.keySet();
    }

    @Override
    public Set<String> getNeighbors(String node) {
        if (this.neighbors.containsKey(node)) {
            return this.neighbors.get(node);
        }
        return new HashSet<String>();
    }
}

