/*
 * Decompiled with CFR 0.152.
 */
package stream.data.storage;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.data.storage.DataService;

public abstract class Store<T extends Serializable>
extends AbstractProcessor
implements DataService<T> {
    static Logger log = LoggerFactory.getLogger(Store.class);
    protected String[] keys;
    protected Integer capacity = 2000;
    protected Map<String, T> data;

    @Override
    public T getData(String key) {
        return (T)((Serializable)this.data.get(key));
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.data = new ConcurrentHashMap<String, T>(this.capacity);
    }

    protected abstract void addData(String[] var1, Data var2);

    @Override
    public Data process(Data input) {
        if (input != null) {
            this.addData(this.keys, input);
        }
        return input;
    }

    @Override
    public void reset() throws Exception {
        this.data.clear();
    }
}

