/*
 * Decompiled with CFR 0.152.
 */
package stream.data.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import stream.AbstractProcessor;
import stream.Data;
import stream.data.TreeNode;
import stream.data.tree.TreeFeature;

public abstract class AbstractTreeFeature
extends AbstractProcessor
implements TreeFeature {
    String id;
    String missingValue = "null";
    String[] keys = null;

    @Override
    public Data process(Data data) {
        ArrayList<String> treeKeys = new ArrayList<String>();
        Iterator<Object> it = this.keys != null ? Arrays.asList(this.keys).iterator() : data.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Serializable value = (Serializable)data.get(key);
            if (value == null || !(value instanceof TreeNode)) continue;
            treeKeys.add(key);
        }
        if (treeKeys.isEmpty()) {
            return data;
        }
        for (String treeKey : treeKeys) {
            this.processTree(treeKey, data);
        }
        return data;
    }

    public void processTree(String treeKey, Data data) {
        TreeNode tree = (TreeNode)data.get(treeKey);
        String featureName = this.createFeatureKey(treeKey);
        Serializable featureValue = this.compute(tree);
        data.put(featureName, featureValue);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public String getMissing() {
        return this.missingValue;
    }

    public void setMissing(String missingValue) {
        this.missingValue = missingValue;
    }

    @Override
    public String createFeatureKey(String inputKey) {
        return this.getId() + "(" + inputKey + ")";
    }

    @Override
    public abstract Serializable compute(TreeNode var1);
}

