/*
 * Decompiled with CFR 0.152.
 */
package stream.expressions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.Data;
import stream.expressions.BooleanOperator;
import stream.expressions.Expression;
import stream.expressions.Match;

public class ExpressionList
implements Expression {
    private static final long serialVersionUID = -6592861898522001021L;
    static Logger log = LoggerFactory.getLogger(ExpressionList.class);
    BooleanOperator op;
    Collection<Expression> exps;

    public ExpressionList(BooleanOperator op, Collection<Expression> exps) {
        this.op = op;
        this.exps = exps;
    }

    public ExpressionList(BooleanOperator op, List<Match> matches) {
        this.op = op;
        this.exps = new LinkedList<Expression>();
        for (Match m : matches) {
            this.exps.add(m);
        }
    }

    public BooleanOperator getOperator() {
        return this.op;
    }

    @Override
    public boolean matches(Context ctx, Data evt) {
        switch (this.op) {
            case OR: {
                return this.or(ctx, evt);
            }
        }
        return this.and(ctx, evt);
    }

    private boolean and(Context ctx, Data evt) {
        log.debug("Asserting all matches!");
        for (Expression exp : this.exps) {
            if (exp.matches(ctx, evt)) continue;
            return false;
        }
        return true;
    }

    private boolean or(Context ctx, Data evt) {
        log.debug("Asserting any match!");
        for (Expression exp : this.exps) {
            if (!exp.matches(ctx, evt)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.exps.size();
    }

    public Collection<Expression> getElements() {
        return this.exps;
    }

    public Expression getFirst() {
        if (this.exps.isEmpty()) {
            return null;
        }
        return this.exps.iterator().next();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("( ");
        for (Expression e : this.exps) {
            if (s.length() > 2) {
                s.append("  " + (Object)((Object)this.op) + "  ");
            }
            s.append(e.toString());
        }
        s.append(" )");
        return s.toString();
    }
}

