/*
 * Decompiled with CFR 0.152.
 */
package stream.expressions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.Data;
import stream.expressions.BinaryOperator;
import stream.expressions.Expression;
import stream.expressions.ExpressionResolver;
import stream.expressions.Operator;

public class Match
implements Expression {
    static Logger log = LoggerFactory.getLogger(Match.class);
    private static final long serialVersionUID = 7007162167342940123L;
    String left;
    Operator op;
    String right;
    boolean negated = false;

    public Match(String left, Operator o, String right) {
        this.left = left;
        this.op = o;
        this.right = right;
        this.negated = o.isNegated();
    }

    @Override
    public boolean matches(Context ctx, Data item) {
        Object rightObject;
        Object leftObject = ExpressionResolver.resolve(this.left, ctx, item);
        if (leftObject == null) {
            leftObject = ExpressionResolver.isMacroObject(this.left) || this.left.equals("null") ? null : this.left;
        }
        if ((rightObject = ExpressionResolver.resolve(this.right, ctx, item)) == null) {
            rightObject = ExpressionResolver.isMacroObject(this.right) || this.right.equals("null") ? null : this.right;
        }
        if (this.op instanceof BinaryOperator) {
            boolean match;
            BinaryOperator binOp = (BinaryOperator)this.op;
            boolean result = match = binOp.eval(leftObject, rightObject);
            if (this.negated) {
                result = !match;
            }
            return result;
        }
        throw new RuntimeException("Unsupported non-binary operator: " + this.op);
    }

    public String toString() {
        return this.left + " " + this.op.toString() + " " + this.right;
    }
}

