/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.expressions.ExpressionResolver;
import stream.flow.If;
import stream.service.Service;

@Description(group="Data Stream.Flow")
public class OnChange
extends If
implements Service {
    static Logger log = LoggerFactory.getLogger(OnChange.class);
    private String key;
    private String oldValue;
    private String from;
    private String to;

    public OnChange() {
        try {
            this.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFrom() {
        return this.from;
    }

    @Parameter(required=false, defaultValue="")
    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    @Parameter(required=false, defaultValue="")
    public void setTo(String to) {
        this.to = to;
    }

    @Parameter(required=true, defaultValue="")
    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public boolean matches(Data item) {
        if (this.key == null) {
            return false;
        }
        String value = String.valueOf(ExpressionResolver.resolve(this.key, this.context, item));
        boolean result = false;
        if (this.from == null && this.to == null) {
            if (this.oldValue == null && (value == null || value.equals("null"))) {
                return false;
            }
            if (this.oldValue == null && value != null) {
                this.oldValue = value;
                return true;
            }
            result = !this.oldValue.equals(value);
            this.oldValue = value;
            return result;
        }
        if (this.from == null && this.to != null) {
            if (this.oldValue == null && (value == null || this.to.equals("null"))) {
                this.oldValue = value;
                return false;
            }
            if (this.oldValue == null && value != null) {
                this.oldValue = value;
                return this.to.equals(value);
            }
            result = !this.oldValue.equals(value) && this.to.equals(value);
            this.oldValue = value;
            return result;
        }
        if (this.from != null && this.to == null) {
            if (this.from.equals("null") && this.oldValue == null && value != null && !"null".equals(value)) {
                this.oldValue = value;
                return true;
            }
            if (this.oldValue == null) {
                this.oldValue = value;
                return false;
            }
            if (this.from.equals("!null")) {
                if (this.oldValue != null && !this.oldValue.equals(value)) {
                    this.oldValue = value;
                    return true;
                }
                if (this.oldValue == null) {
                    return false;
                }
            }
            if (this.from.equals(this.oldValue) && (value == null || !this.from.equals(value))) {
                this.oldValue = value;
                return true;
            }
        } else {
            if (this.from.equals(this.to)) {
                return false;
            }
            if (this.from.equals("null") && this.oldValue == null && this.to.equals(value)) {
                this.oldValue = value;
                return true;
            }
            if (this.from.equals(this.oldValue) && this.to.equals(value)) {
                this.oldValue = value;
                return true;
            }
        }
        this.oldValue = value;
        return false;
    }

    @Override
    public void reset() throws Exception {
        this.oldValue = null;
    }
}

