/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataFactory;
import stream.generator.Gaussian;
import stream.generator.GeneratorDataStream;

public class GaussianStream
extends GeneratorDataStream {
    static Logger log = LoggerFactory.getLogger(GaussianStream.class);
    Map<String, Gaussian> generators = new LinkedHashMap<String, Gaussian>();
    Map<String, Class<?>> types = new LinkedHashMap();
    Random random = new Random();
    Long seed = System.currentTimeMillis();
    Random seedGenerator = new Random();
    Double[] attributes;
    Long limit = -1L;
    Long count = 0L;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.attributes == null && this.generators.isEmpty()) {
            throw new Exception("Parameter 'attributes' missing! This should be a list of mean,deviation pairs!");
        }
        if (this.attributes != null) {
            int cnt = 1;
            int i = 0;
            while (i + 1 < this.attributes.length) {
                this.setGenerator("x" + cnt, new Gaussian(this.attributes[i], this.attributes[i + 1]));
                ++cnt;
                i += 2;
            }
        }
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
        this.random = new Random(this.seed);
        this.seedGenerator = new Random(this.seed);
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Data generate() {
        Data item = DataFactory.create();
        for (String attribute : this.generators.keySet()) {
            Gaussian g = this.generators.get(attribute);
            item.put(attribute, g.next());
        }
        return item;
    }

    public void setGenerator(String attribute, Gaussian dist) {
        this.generators.put(attribute, dist);
        if (!this.types.containsKey(attribute)) {
            this.types.put(attribute, Double.class);
        }
        if (dist.getSeed() == null) {
            Long seed = this.getNextSeed();
            log.info("Setting seed for new generator to {}", (Object)seed);
            dist.setSeed(seed);
        }
    }

    public void setAttributes(Double[] attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Class<?>> getAttributes() {
        return this.types;
    }

    @Override
    public Data readNext() throws Exception {
        return this.readNext(DataFactory.create());
    }

    @Override
    public Data readNext(Data item) throws Exception {
        if (this.limit > 0L && this.count >= this.limit) {
            return null;
        }
        Data gen = this.generate();
        item.clear();
        item.putAll(gen);
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        return item;
    }

    public String getDescription() {
        StringBuffer s = new StringBuffer();
        s.append("<p>");
        s.append("This is a pseudo-randomized generated data stream, consisting of " + this.types.size() + " attributes. <br/>");
        s.append("The attributes are { " + this.generators.keySet() + " } and are independently generated using the");
        s.append("following generators:");
        s.append("<table>");
        for (String att : this.types.keySet()) {
            s.append("<tr>");
            s.append("<td>");
            s.append(att);
            s.append("</td>");
            s.append("<td>");
            Gaussian g = this.generators.get(att);
            s.append("mean: " + g.getMean() + ", variance: " + g.getVariance());
            s.append("</td>");
            s.append("</tr>");
        }
        s.append("</p>");
        return s.toString();
    }

    public Long getNextSeed() {
        return this.seedGenerator.nextLong();
    }

    @Override
    public void close() {
    }
}

