/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.AbstractDataStream;

@Description(group="Data Stream.Sources.Synthetic")
public class RandomStream
extends AbstractDataStream {
    Map<String, Class<?>> attributes = new LinkedHashMap();
    Map<String, Object> store = new LinkedHashMap<String, Object>();
    Random[] random = null;
    String[] keys = new String[]{"att1"};

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(required=false, description="The attribute names to create (comma separated)")
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    @Override
    public Map<String, Class<?>> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap();
            for (String key : this.keys) {
                this.attributes.put(key, Double.class);
            }
        }
        return this.attributes;
    }

    @Override
    public Data readNext() throws Exception {
        Data map = DataFactory.create();
        return this.readNext(map);
    }

    @Override
    public Data readItem(Data data) throws Exception {
        if (data == null) {
            data = DataFactory.create();
        }
        if (this.keys == null) {
            this.keys = new String[]{"x1"};
        }
        if (this.random == null) {
            this.random = new Random[this.keys.length];
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.random[i] == null) {
                this.random[i] = new Random((long)i * 1000L);
            }
            data.put(this.keys[i], this.next(this.random[i]));
        }
        return data;
    }

    public Double next(Random rnd) {
        return rnd.nextGaussian();
    }

    public Object get(String key) {
        return this.store.get(key);
    }

    public Object get(String key, Object init) {
        if (this.store.get(key) == null) {
            this.store.put(key, init);
            return init;
        }
        return this.store.get(key);
    }

    public void set(String key, Object val) {
        this.store.put(key, val);
    }

    @Override
    public void close() {
    }

    @Override
    public void readHeader() throws Exception {
    }
}

