/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.io.AbstractDataStream;

@Description(group="Data Stream.Sources")
public class ArffStream
extends AbstractDataStream {
    static Logger log = LoggerFactory.getLogger(ArffStream.class);

    public ArffStream(URL url) throws Exception {
        super(url);
    }

    @Override
    public void readHeader() throws Exception {
        String line = this.reader.readLine();
        while (line != null && !line.startsWith("@data")) {
            if (line.startsWith("@attribute")) {
                String[] tok = line.split("\\s");
                Class<Object> clazz = Object.class;
                if ("numeric".equalsIgnoreCase(tok[2].trim())) {
                    clazz = Double.class;
                }
                String app = "";
                int i = 0;
                while (this.attributes.containsKey(tok[1] + app)) {
                    app = "_" + i++;
                }
                this.attributes.put(tok[1] + app, clazz);
            }
            line = this.reader.readLine();
        }
        log.info("Attributes of Arff-Stream: {}", (Object)this.attributes);
    }

    @Override
    public Data readItem(Data datum) throws Exception {
        if (datum == null) {
            datum = DataFactory.create();
        }
        String line = this.reader.readLine();
        while (line != null && line.trim().isEmpty()) {
            line = this.reader.readLine();
        }
        if (line != null && !line.trim().equals("")) {
            String[] tok = line.split(",");
            int i = 0;
            for (String name : this.attributes.keySet()) {
                if (i >= tok.length) break;
                if (Double.class.equals(this.attributes.get(name))) {
                    datum.put(name, new Double(tok[i]));
                } else {
                    datum.put(name, tok[i]);
                }
                ++i;
            }
        }
        return datum;
    }

    @Override
    public void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.error("Failed to properly close reader: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }
}

