/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialFileInputStream
extends InputStream {
    static Logger log = LoggerFactory.getLogger(SequentialFileInputStream.class);
    Integer sleep = 1000;
    File file = null;
    File current = null;
    Long currentOffset = 0L;
    File next = null;
    BufferedReader reader;
    boolean removeAfterRead = true;
    Long startTime = 0L;
    boolean running = true;
    Long toSkip = 0L;
    FileHandler oldFileHandler = null;

    public SequentialFileInputStream(File file) throws IOException {
        this(file, 0L, false);
    }

    public SequentialFileInputStream(File file, long start, boolean removeAfterRead) throws IOException {
        this.current = this.file = file;
        this.startTime = start;
        this.removeAfterRead = removeAfterRead;
        if (removeAfterRead) {
            this.oldFileHandler = new FileHandler(){

                @Override
                public void handle(File file) throws Exception {
                    file.delete();
                }
            };
        }
    }

    public File getCurrentFile() {
        return this.current;
    }

    public Long getCurrentOffset() {
        return this.currentOffset;
    }

    public FileHandler getOldFileHandler() {
        return this.oldFileHandler;
    }

    public void setOldFileHandler(FileHandler oldFileHandler) {
        this.oldFileHandler = oldFileHandler;
    }

    public boolean matchesSequence(File f) {
        if (log.isTraceEnabled()) {
            log.trace("checking file {}", (Object)f);
            log.trace("   start-time: {}", (Object)this.startTime);
            log.trace("   f.last-mod: {}  ({})", (Object)f.lastModified(), (Object)new Date(f.lastModified()));
        }
        if (f.isFile() && (f.equals(this.file) || f.getName().matches(this.file.getName() + "(\\.\\d+)?"))) {
            if (this.reader == null || f.lastModified() > this.current.lastModified()) {
                return true;
            }
            log.debug("Current file {} is still newer than {}", (Object)this.current, (Object)f);
        }
        return false;
    }

    public boolean hasNext() {
        File dir = this.file.getParentFile();
        for (File f : dir.listFiles()) {
            if (!this.matchesSequence(f)) continue;
            return true;
        }
        return false;
    }

    protected void openNextFile() throws IOException {
        log.debug("Current file {} seems to have ended, checking for next one", (Object)this.current);
        boolean proceeded = false;
        do {
            TreeSet<File> files = new TreeSet<File>();
            File dir = this.file.getParentFile();
            for (File f : dir.listFiles()) {
                if (!this.matchesSequence(f) || this.startTime > f.lastModified()) continue;
                log.debug("  File {}  (last-modified-at {}) is considered a candidate to proceed", (Object)f, (Object)f.lastModified());
                if (this.startTime <= f.lastModified()) {
                    files.add(f);
                    continue;
                }
                log.debug("Skipping file {} which has modification " + f.lastModified() + " time BEFORE offset-time ({})", (Object)f, (Object)this.startTime);
            }
            TreeSet<File> sequence = files;
            log.debug("candidate files: {}", (Object)sequence);
            if (!sequence.isEmpty()) {
                if (this.reader != null) {
                    log.debug("Closing old reader...");
                    this.reader.close();
                }
                try {
                    if (this.oldFileHandler != null) {
                        this.oldFileHandler.handle(this.current);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.current = (File)sequence.first();
                this.startTime = this.current.lastModified();
                this.currentOffset = 0L;
                this.reader = new BufferedReader(new FileReader(this.current));
                if (this.toSkip > 0L) {
                    log.debug("Skipping {} bytes", (Object)this.toSkip);
                    Long skipped = this.reader.skip(this.toSkip);
                    this.toSkip = 0L;
                    SequentialFileInputStream sequentialFileInputStream = this;
                    Long.valueOf(sequentialFileInputStream.currentOffset + skipped);
                    sequentialFileInputStream.currentOffset = sequentialFileInputStream.currentOffset;
                }
                proceeded = true;
            } else {
                if (!this.running) {
                    log.trace("file-reader closed, returning!");
                    return;
                }
                log.debug("sequential reader running? {}", (Object)this.running);
                try {
                    log.debug("No sequential file found for {}, sleeping for {} ms and checking again...", (Object)this.file, (Object)this.sleep);
                    Thread.sleep(this.sleep.intValue());
                }
                catch (Exception e) {
                    log.debug("seq-file-reader running? {}", (Object)this.running);
                    e.printStackTrace();
                }
            }
            if (this.running) continue;
            return;
        } while (this.running && !proceeded);
    }

    public synchronized String readLine() {
        if (!this.running) {
            return null;
        }
        try {
            while (this.reader == null) {
                log.trace("reader is null, opening next file...");
                this.openNextFile();
                if (!this.running) {
                    return null;
                }
                if (this.reader != null) continue;
                log.trace("Waiting for new file to become available...");
                Thread.sleep(this.sleep.intValue());
            }
            log.trace("Reading line from {}...", (Object)this.current);
            String line = this.reader.readLine();
            while (line == null) {
                if (!this.running) {
                    return null;
                }
                if (line == null && this.hasNext()) {
                    log.trace("Switching to next file...");
                    this.openNextFile();
                } else {
                    log.trace("Waiting for lines to be appended to {}", (Object)this.current);
                    Thread.sleep(this.sleep.intValue());
                }
                log.trace("Reading next line from {}...", (Object)this.current);
                line = this.reader.readLine();
                log.trace("   line is: {}", (Object)line);
            }
            log.trace("Read line (from {}): {}", (Object)this.current, (Object)line);
            this.currentOffset = this.currentOffset + (long)(line.getBytes().length + 1);
            return line;
        }
        catch (InterruptedException ie) {
            if (this.running) {
                log.error("interrupted-exception, but reader still running: {}", (Object)ie.getMessage());
                ie.printStackTrace();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSource() {
        return this.current + "";
    }

    @Override
    public long skip(long bytes) {
        long skipped;
        block4: {
            skipped = 0L;
            try {
                if (this.reader != null) {
                    skipped = this.reader.skip(bytes);
                    SequentialFileInputStream sequentialFileInputStream = this;
                    sequentialFileInputStream.currentOffset = sequentialFileInputStream.currentOffset + skipped;
                } else {
                    this.toSkip = bytes;
                }
            }
            catch (Exception e) {
                log.error("Failed to skip {} bytes: {}", (Object)bytes, (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        return skipped;
    }

    public Long bytesRead() {
        return this.getCurrentOffset();
    }

    @Override
    public void close() {
        log.trace("Closing sequential-file-reader");
        this.running = false;
    }

    @Override
    public int read() throws IOException {
        int data = this.reader.read();
        if (data >= 0) {
            Long l = this.currentOffset;
            Long l2 = this.currentOffset = Long.valueOf(this.currentOffset + 1L);
        }
        return data;
    }

    public static interface FileHandler {
        public void handle(File var1) throws Exception;
    }
}

