/*
 * Decompiled with CFR 0.152.
 */
package stream;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.StreamRuntime;

public class run {
    static Logger log = LoggerFactory.getLogger(run.class);
    private static String version;

    public static void setupOutput() throws Exception {
        if (System.getProperty("container.stdout") != null) {
            System.setOut(new PrintStream(new FileOutputStream(System.getProperty("container.stdout"))));
        }
        if (System.getProperty("container.stderr") != null) {
            System.setOut(new PrintStream(new FileOutputStream(System.getProperty("container.stdout"))));
        }
    }

    public static List<String> handleArguments(String[] args) {
        if (args.length == 0) {
            System.out.println("streams, Version " + run.getVersion());
            System.out.println();
            System.out.println("No container file specified.");
            System.out.println();
            System.out.println("Usage: ");
            System.out.println("\tstream.run /path/container-file.xml");
            System.out.println();
            return null;
        }
        for (String arg : args) {
            if (!arg.equals("-v") && !"--version".equals(args)) continue;
            System.out.println("streams, Version " + run.getVersion());
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                int idx = arg.indexOf("=");
                String key = null;
                String value = "";
                if (idx > 2) {
                    key = arg.substring(2, idx);
                    value = arg.substring(idx + 1);
                } else {
                    key = arg.substring(2);
                }
                log.info("Setting property '{}' = '{}'", (Object)key, (Object)value);
                System.setProperty(key, value);
                continue;
            }
            log.info("Adding argument '{}'", (Object)arg);
            list.add(arg);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        URL url;
        List<String> params = run.handleArguments(args);
        if (params == null || params.isEmpty()) {
            return;
        }
        run.setupOutput();
        try {
            url = new URL(params.get(0));
        }
        catch (Exception e) {
            File f = new File(params.get(0));
            url = f.toURI().toURL();
        }
        run.main(url);
    }

    public static void main(URL url) throws Exception {
        run.setupOutput();
        StreamRuntime.setupLogging();
        log.debug("Creating process-container from configuration at {}", (Object)url);
        ProcessContainer container = new ProcessContainer(url);
        log.info("Starting process-container...");
        container.run();
        log.info("Container finished.");
        System.exit(0);
    }

    public static void main(URL url, Map<String, ElementHandler> elementHandler) throws Exception {
        StreamRuntime.setupLogging();
        log.debug("Creating process-container from configuration at {}", (Object)url);
        ProcessContainer container = new ProcessContainer(url, elementHandler);
        log.info("Starting process-container...");
        container.run();
        log.info("Container finished.");
        System.exit(0);
    }

    public static void main(String resource) throws Exception {
        log.info("Looking for configuration at resource {} in classpath", (Object)resource);
        run.main(run.class.getResource(resource));
    }

    public static void main(String resource, Map<String, ElementHandler> elementHandler) throws Exception {
        log.info("Looking for configuration at resource {} in classpath", (Object)resource);
        run.main(run.class.getResource(resource), elementHandler);
    }

    public static synchronized String getVersion() {
        Package aPackage;
        if (version != null) {
            return version;
        }
        try {
            Properties p = new Properties();
            InputStream is = run.class.getResourceAsStream("/META-INF/maven/org.jwall/stream-api/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (version == null && (aPackage = run.class.getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            version = "";
        }
        return version;
    }
}

