/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.DataStream;
import stream.runtime.AbstractProcess;
import stream.runtime.DataStreamConsumer;

public class Process
extends AbstractProcess
implements DataStreamConsumer {
    static Logger log = LoggerFactory.getLogger(Process.class);
    static Integer LAST_ID = 0;
    DataStream dataStream;
    Long limit = -1L;
    String input;
    String output;

    public Process() {
        this.interval = 0L;
    }

    public void setInput(String input) {
        this.input = input;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public void setDataStream(DataStream ds) {
        this.dataStream = ds;
    }

    @Override
    public DataStream getDataStream() {
        return this.dataStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data getNextItem() {
        try {
            if (this.limit > 0L && this.count > this.limit) {
                log.debug("Limit '{}' reached, no more data from the input will be processed.");
                return null;
            }
            Data item = null;
            for (int tries = 0; item == null && tries < 10; ++tries) {
                try {
                    log.trace("Reading next item from {}", (Object)this.dataStream);
                    DataStream dataStream = this.dataStream;
                    synchronized (dataStream) {
                        item = this.dataStream.readNext();
                    }
                    tries = 0;
                    return item;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to read next item from input '{}'", (Object)this.dataStream);
            throw new RuntimeException("Failed to read next item from input '" + this.dataStream + "': " + e.getMessage());
        }
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }
}

