/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.dependencies;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dependency {
    static Logger log = LoggerFactory.getLogger(Dependency.class);
    final String groupId;
    final String artifactId;
    final String version;

    public Dependency(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public File getLocalFile() {
        StringBuffer s = new StringBuffer(System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository" + File.separator);
        s.append(this.getPath());
        File file = new File(s.toString());
        return file;
    }

    public String getPath() {
        return this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.artifactId + "-" + this.version + ".jar";
    }

    public String getPomPath() {
        return this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.artifactId + "-" + this.version + ".pom";
    }

    public File download() throws Exception {
        StringBuffer s = new StringBuffer("http://repo.maven.apache.org/maven2/");
        s.append(this.getPath());
        URL url = new URL(s.toString());
        InputStream in = url.openStream();
        log.info("Downloading library {} from {}", (Object)this.artifactId, (Object)url);
        File file = new File(System.getProperty("user.home") + "/.streams/" + this.artifactId + "-" + this.version + ".jar");
        File lib = new File(System.getProperty("user.home") + File.separator + ".streams" + File.separator + this.getPath());
        lib.getParentFile().mkdirs();
        file = lib;
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[8192];
        int total = 0;
        int read = in.read(buf);
        while (read > 0) {
            total += read;
            out.write(buf, 0, read);
            read = in.read(buf);
        }
        log.info("{} bytes fetched.", (Object)total);
        out.close();
        return file;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dependency) {
            return this.toString().compareTo(obj.toString()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }
}

