/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.Parameter;
import stream.runtime.setup.ParameterInjection;

public class ParameterDiscovery {
    static Logger log = LoggerFactory.getLogger(ParameterDiscovery.class);

    public static Map<String, Class<?>> discoverParameters(Class<?> clazz) {
        LinkedHashMap types = new LinkedHashMap();
        for (Method m : clazz.getMethods()) {
            Parameter param;
            if (!ParameterDiscovery.isSetter(m)) continue;
            log.info("Found setter '{}'", (Object)m.getName());
            String key = m.getName().substring(3, 4).toLowerCase();
            if (m.getName().length() > 4) {
                key = key + m.getName().substring(4);
            }
            if ((param = m.getAnnotation(Parameter.class)) != null) {
                log.info("setter-method is annotated: {}", (Object)param);
                if (param.name() != null && !param.name().isEmpty()) {
                    key = param.name();
                }
            }
            if (!types.containsKey(key)) {
                log.info("  => parameter '{}'", (Object)key);
                types.put(key, m.getParameterTypes()[0]);
                continue;
            }
            log.info("Parameter {} already defined by field-annotation", (Object)key);
        }
        return types;
    }

    public static Parameter getParameterAnnotation(Class<?> clazz, String key) {
        for (Method m : clazz.getMethods()) {
            if (!ParameterDiscovery.isSetter(m) || !m.getName().toLowerCase().equals("set" + key.toLowerCase())) continue;
            Parameter p = m.getAnnotation(Parameter.class);
            log.debug("Found parameter annotation for class {}, key {}: " + p, (Object)clazz, (Object)key);
            return p;
        }
        return null;
    }

    public static Class<?> getParameterType(Class<?> clazz, String name) {
        for (Method m : clazz.getMethods()) {
            if (!ParameterDiscovery.isSetter(m) || !m.getName().toLowerCase().equals("set" + name.toLowerCase())) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public static List<Parameter> discoverParameterAnnotations(Class<?> clazz) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Field[] fields = clazz.getDeclaredFields();
        log.info("Found {} fields", (Object)fields.length);
        for (Method m : clazz.getMethods()) {
            Parameter param = m.getAnnotation(Parameter.class);
            if (param != null) {
                log.info("Found @parameter annotated field '{}'", (Object)m.getName());
                log.info("    field.getType() = {}", m.getParameterTypes());
                parameters.add(param);
                continue;
            }
            log.info("Field '{}' is not annotated as parameter", (Object)m.getName());
        }
        return parameters;
    }

    public static String getParameterName(Method m) {
        if (ParameterDiscovery.isGetter(m)) {
            String key = m.getName().substring(3, 4).toLowerCase();
            if (m.getName().length() > 3) {
                key = key + m.getName().substring(4);
            }
            return key;
        }
        return null;
    }

    public static boolean isGetter(Method m) {
        Class<?> rt;
        return m.getName().toLowerCase().startsWith("get") && ParameterInjection.isTypeSupported(rt = m.getReturnType());
    }

    public static boolean isSetter(Method m) {
        Class<?> rt;
        return m.getName().toLowerCase().startsWith("set") && m.getParameterTypes().length == 1 && ParameterInjection.isTypeSupported(rt = m.getParameterTypes()[0]);
    }

    public static Map<String, String> getProperties(String prefix, Properties p) {
        String pre = prefix;
        if (!pre.endsWith(".")) {
            pre = pre + ".";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Object o : p.keySet()) {
            String key = o.toString();
            if (!key.startsWith(pre)) continue;
            params.put(key.substring(pre.length()), p.getProperty(key));
        }
        return params;
    }

    public static Map<String, String> getSystemProperties(String prefix) {
        return ParameterDiscovery.getProperties(prefix, System.getProperties());
    }
}

