/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.util.Map;
import org.w3c.dom.Element;
import stream.io.DataStreamQueue;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;

public class QueueElementHandler
implements ElementHandler {
    @Override
    public String getKey() {
        return "Queue";
    }

    @Override
    public boolean handlesElement(Element element) {
        return this.getKey().equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element) throws Exception {
        String id;
        Map<String, String> params;
        String className = element.getAttribute("class");
        if (className == null || className.trim().isEmpty()) {
            className = "stream.io.BlockingQueue";
        }
        if (!(params = container.getObjectFactory().getAttributes(element)).containsKey("class")) {
            params.put("class", "stream.io.BlockingQueue");
        }
        if ((id = element.getAttribute("id")) == null || id.trim().isEmpty()) {
            throw new Exception("No 'id' attribute defined for queue!");
        }
        DataStreamQueue queue = (DataStreamQueue)container.getObjectFactory().create(className, params);
        container.registerQueue(id, queue);
    }
}

