/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.shutdown;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.LifeCycle;

public class DependencyGraph {
    static Logger log = LoggerFactory.getLogger(DependencyGraph.class);
    final Set<Object> nodes = new LinkedHashSet<Object>();
    final List<Edge> edges = new ArrayList<Edge>();

    public synchronized void add(Object from, Object to) {
        this.nodes.add(from);
        this.nodes.add(to);
        this.edges.add(new Edge(from, to));
        this.notify();
    }

    public synchronized Set<Object> getSources() {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            nodes.add(edge.getFrom());
        }
        return nodes;
    }

    public synchronized Set<Object> getTargets(Object from) {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            if (edge.getFrom() != from) continue;
            nodes.add(edge.getTo());
        }
        return nodes;
    }

    public synchronized Set<Object> getReferencedObjects() {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            nodes.add(edge.getTo());
        }
        return nodes;
    }

    public synchronized Set<Object> getSourcesFor(Object target) {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            if (edge.getTo() != target) continue;
            nodes.add(edge.getFrom());
        }
        return nodes;
    }

    public synchronized Set<Object> getIsolated() {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Object node : this.nodes) {
            if (!this.getSourcesFor(node).isEmpty()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public synchronized void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.notify();
    }

    public synchronized List<LifeCycle> remove(Object o) {
        if (!this.nodes.contains(o)) {
            return new ArrayList<LifeCycle>();
        }
        List<LifeCycle> objs = this.remove(o, false);
        this.notifyAll();
        return objs;
    }

    private synchronized List<LifeCycle> remove(Object o, boolean notify) {
        log.debug("Removing {} from dependency-graph...", o);
        ArrayList<LifeCycle> lifeObjects = new ArrayList<LifeCycle>();
        if (!this.nodes.contains(o)) {
            return lifeObjects;
        }
        if (o instanceof LifeCycle) {
            lifeObjects.add((LifeCycle)o);
        }
        for (Edge edge : new ArrayList<Edge>(this.edges)) {
            if (edge.getFrom() != o) continue;
            this.nodes.remove(o);
            this.edges.remove(edge);
            Object target = edge.getTo();
            if (!this.getSourcesFor(target).isEmpty()) continue;
            log.trace("[graph-shutdown]     -> No more references to {}, adding to shutdown-queue", target);
            lifeObjects.addAll(this.remove(target, notify));
        }
        log.trace("[dep-graph]  Reference counts: ");
        for (Object node : this.nodes) {
            log.trace("[dep-graph]     * {}  is referenced by {} ", node, (Object)this.getSourcesFor(node));
        }
        return lifeObjects;
    }

    public synchronized void printShutdownStrategy() {
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(this.nodes);
        LinkedHashSet finished = new LinkedHashSet();
        LinkedBlockingQueue<Object> waiting = new LinkedBlockingQueue<Object>();
        waiting.addAll(this.getIsolated());
        while (!waiting.isEmpty()) {
            Object next = waiting.poll();
            log.trace("[graph-shutdown]   Shutting down {}", next);
            finished.add(next);
            all.remove(next);
        }
        log.trace("[dep-graph]  Reference counts: ");
        for (Object node : this.nodes) {
            log.trace("[dep-graph]     * {}  is referenced by {} objects", node, (Object)this.getSourcesFor(node).size());
        }
    }

    public static class Edge {
        static Integer lastId = 0;
        final Integer id;
        final Object from;
        final Object to;

        public Edge(Object from, Object to) {
            Integer n = lastId;
            Integer n2 = lastId = Integer.valueOf(lastId + 1);
            this.id = n;
            this.from = from;
            this.to = to;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }
}

