/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.shutdown;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.io.DataStream;
import stream.runtime.Monitor;
import stream.runtime.Process;
import stream.runtime.shutdown.AbstractShutdownCondition;
import stream.runtime.shutdown.DependencyGraph;

public class LocalShutdownCondition
extends AbstractShutdownCondition {
    static Logger log = LoggerFactory.getLogger(LocalShutdownCondition.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMet(DependencyGraph graph) {
        DependencyGraph dependencyGraph = graph;
        synchronized (dependencyGraph) {
            if (graph.nodes.isEmpty()) {
                return true;
            }
            ArrayList<Monitor> monitors = new ArrayList<Monitor>();
            int processes = 0;
            int monitorCount = 0;
            for (Object node : graph.nodes) {
                if (node instanceof Process && !(node instanceof Monitor)) {
                    ++processes;
                }
                if (!(node instanceof Monitor)) continue;
                monitors.add((Monitor)node);
                ++monitorCount;
            }
            if (processes == 0) {
                log.debug("No more processes running...");
                for (Monitor m : monitors) {
                    try {
                        log.debug("Finishing monitor {}", (Object)m);
                        m.finish();
                        log.debug("Removing monitor {} from dependency graph", (Object)m);
                        graph.remove(m);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (processes == 0 && monitorCount == 0) {
                log.debug("All monitors, all processes have finished!");
                return true;
            }
            for (Object node : graph.nodes) {
                if (node instanceof DataStream || node instanceof Monitor || graph.getSourcesFor(node).isEmpty()) continue;
                log.debug("Found referenced node '{}' with {} references -> shutdown condition not met.", node, (Object)graph.getSourcesFor(node).size());
                log.debug("   references are: {}", (Object)graph.getSourcesFor(node));
                return false;
            }
            log.debug("shutdown-condition fulfilled!");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCondition(DependencyGraph graph) {
        DependencyGraph dependencyGraph = graph;
        synchronized (dependencyGraph) {
            while (!this.isMet(graph)) {
                try {
                    log.debug("shutdown-condition not met, waiting for changes in the dependency-graph...");
                    graph.wait();
                }
                catch (Exception e) {
                    log.error("Error while waiting for shutdown-condition: {}", (Object)e.getMessage());
                    if (!log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
            }
        }
    }
}

