/*
 * Decompiled with CFR 0.152.
 */
package stream.script;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.StatefulProcessor;
import stream.annotations.Description;
import stream.script.Script;
import stream.util.URLUtilities;

@Description(group="Data Stream.Processing.Script")
public class JavaScript
extends Script {
    static Logger log = LoggerFactory.getLogger(JavaScript.class);
    static final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    static final String preamble = URLUtilities.readContentOrEmpty(JavaScript.class.getResource("/stream/data/JavaScript.preamble"));
    transient String theScript = null;
    String script = null;
    Invocable impl;

    public JavaScript() {
        super(scriptEngineManager.getEngineByName("JavaScript"));
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        block6: {
            super.init(ctx);
            this.script = this.loadScript();
            try {
                this.initScript();
                if (this.impl != null && this.impl instanceof StatefulProcessor) {
                    try {
                        ((StatefulProcessor)((Object)this.impl)).init(ctx);
                    }
                    catch (NoSuchMethodException nsm) {
                        log.warn("No init() function defined in JavaScript.");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while initializing script: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
    }

    @Override
    public Data process(Data data) {
        try {
            if (this.script == null) {
                log.debug("No script loaded, skipping script execution...");
                return data;
            }
            if (this.impl != null) {
                try {
                    log.debug("Calling JavaScript implementation of processor interface...");
                    data = (Data)this.impl.invokeFunction("process", data);
                    return data;
                }
                catch (NoSuchMethodException nsme) {
                    log.warn("No function 'process(data)' defined, evaluating running script code!");
                }
            }
            log.debug("Script loaded is:\n{}", (Object)this.script);
            ScriptContext ctx = this.scriptEngine.getContext();
            this.scriptEngine.put("data", data);
            this.scriptEngine.put("process", this.context);
            log.debug("Evaluating script...");
            this.scriptEngine.eval(this.script, ctx);
        }
        catch (Exception e) {
            log.error("Failed to execute script: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new RuntimeException("Script execution error: " + e.getMessage());
        }
        log.debug("Returning data: {}", (Object)data);
        return data;
    }

    @Override
    protected String loadScript() throws Exception {
        if (this.embedded != null) {
            log.info("Using embedded content...");
            this.theScript = preamble + "\n" + this.embedded.getContent();
            return this.theScript;
        }
        if (this.file != null) {
            log.debug("Reading script from file {}", (Object)this.file);
            this.theScript = this.loadScript(new FileInputStream(this.file));
            return this.theScript;
        }
        throw new Exception("Neither embedded script not script file provided!");
    }

    @Override
    protected String loadScript(InputStream in) throws Exception {
        log.debug("Loading script from input-stream {}", (Object)in);
        StringBuffer s = new StringBuffer();
        s.append(preamble);
        s.append("\n");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            s.append(line + "\n");
            log.debug("Appending line: {}", (Object)line);
            line = reader.readLine();
        }
        reader.close();
        return s.toString();
    }

    private void initScript() throws Exception {
        log.debug("Script loaded is:\n{}", (Object)this.script);
        ScriptContext ctx = this.scriptEngine.getContext();
        this.scriptEngine.put("process", this.context);
        log.debug("Evaluating script...");
        this.scriptEngine.eval(this.script, ctx);
        if (this.scriptEngine instanceof Invocable) {
            Invocable invocable;
            this.impl = invocable = (Invocable)((Object)this.scriptEngine);
            if (this.impl != null) {
                log.info("JavaScript implements StatefulProcessor interface!!");
                return;
            }
            log.debug("Found JavaScript implementation of processor interface...");
        }
    }
}

