/*
 * Decompiled with CFR 0.152.
 */
package stream.shell;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Shell;
import stream.runtime.rpc.ContainerAnnouncement;
import stream.runtime.rpc.Discovery;
import stream.runtime.rpc.RMIClient;
import stream.service.NamingService;
import stream.service.ServiceInfo;
import stream.shell.Command;

public class Discover
extends Command {
    static Logger log = LoggerFactory.getLogger(Discover.class);
    Discovery discovery = new Discovery();

    public Discover(Shell shell) throws Exception {
        super(shell);
    }

    @Override
    public String execute(String[] args) {
        this.println("\nContainer:\n----------\n");
        log.info("Running discovery.discover()");
        try {
            this.discovery.discover();
            int id = 1;
            for (String key : this.discovery.getAnnouncements().keySet()) {
                NamingService remote;
                ContainerAnnouncement ref = this.discovery.getAnnouncements().get(key);
                log.info("Adding RMI connection for container {}", (Object)ref);
                if (this.shell.getNamingService().getContainer(key) != null) {
                    log.info("Container already known: {}", (Object)this.shell.getNamingService().getContainer(key));
                    remote = this.shell.getNamingService().getContainer(key);
                } else {
                    remote = new RMIClient(ref.getHost(), ref.getPort());
                    this.shell.getNamingService().addContainer(key, remote);
                }
                this.println("   #" + id + "  " + key + "  [" + this.shell.getNamingService().getContainer(key) + "]");
                this.shell.set("#" + id, key);
                ++id;
                Map<String, ServiceInfo> infos = remote.list();
                for (String name : infos.keySet()) {
                    if (name.startsWith("//" + key + "/.")) continue;
                    ServiceInfo info = infos.get(name);
                    StringBuffer services = new StringBuffer("[");
                    for (int i = 0; i < info.getServices().length; ++i) {
                        services.append(info.getServices()[i].getCanonicalName());
                        if (i + 1 >= info.getServices().length) continue;
                        services.append(", ");
                    }
                    services.append("]");
                    this.println("     + " + name + "    " + services.toString());
                }
            }
            this.println("");
        }
        catch (Exception e) {
            this.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
        return "";
    }
}

