/*
 * Decompiled with CFR 0.152.
 */
package stream.shell;

import java.lang.reflect.Method;
import stream.Shell;
import stream.runtime.DefaultNamingService;
import stream.service.Service;
import stream.shell.Command;

public class Info
extends Command {
    public Info(Shell shell) {
        super(shell);
    }

    @Override
    public String execute(String[] args) {
        try {
            DefaultNamingService ns = this.shell.getNamingService();
            Service service = ns.lookup(args[0], Service.class);
            this.println(":> " + service);
            for (Class<?> intf : service.getClass().getInterfaces()) {
                this.println("[" + intf.getCanonicalName() + "]");
                for (Method m : intf.getMethods()) {
                    String rt = "void";
                    if (m.getReturnType() != null) {
                        rt = m.getReturnType().getCanonicalName();
                    }
                    this.print("  -> public " + rt + " " + m.getName() + "(");
                    if (m.getParameterTypes().length > 0) {
                        for (int i = 0; i < m.getParameterTypes().length; ++i) {
                            this.print(m.getParameterTypes()[i].getCanonicalName() + "");
                            if (i + 1 >= m.getParameterTypes().length) continue;
                            this.print(",");
                        }
                    }
                    this.println(")");
                }
            }
        }
        catch (Exception e) {
            this.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
        return "";
    }
}

