/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static final String UUID_ATTRIBUTE = "stream.storm.uuid";

    public static Document parseDocument(String xmlString) throws Exception {
        return XMLUtils.parseDocument(new ByteArrayInputStream(xmlString.getBytes()));
    }

    public static Document parseDocument(File file) throws Exception {
        return XMLUtils.parseDocument(new FileInputStream(file));
    }

    public static Document parseDocument(InputStream in) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(in);
    }

    public static String toString(Document doc) throws Exception {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter out = new StringWriter();
        StreamResult output = new StreamResult(out);
        trans.transform(source, output);
        String xml = out.toString();
        return xml;
    }

    public static Document addUUIDAttributes(Document doc, String attributeName) {
        if (doc != null && doc.getDocumentElement() != null) {
            XMLUtils.addUUIDAttributes(doc.getDocumentElement(), attributeName);
        }
        return doc;
    }

    public static void addUUIDAttributes(Element element, String attributeName) {
        if (element.hasAttribute(UUID_ATTRIBUTE)) {
            return;
        }
        UUID id = UUID.randomUUID();
        element.setAttribute(UUID_ATTRIBUTE, id.toString());
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            XMLUtils.addUUIDAttributes((Element)node, attributeName);
        }
    }

    public static String createIDs(InputStream in, String attributeName) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        XMLUtils.addUUIDAttributes(doc.getDocumentElement(), attributeName);
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        StreamSource source = new StreamSource(in);
        StringWriter out = new StringWriter();
        StreamResult output = new StreamResult(out);
        trans.transform(source, output);
        String xml = out.toString();
        return xml;
    }

    public static Element findElementByUUID(Element el, String attributeName, String uuid) {
        String id = el.getAttribute(attributeName);
        if (uuid.equals(id)) {
            return el;
        }
        NodeList list = el.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element found;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || (found = XMLUtils.findElementByUUID((Element)node, attributeName, uuid)) == null) continue;
            return found;
        }
        return null;
    }

    public static Element findElementByUUID(Document doc, String attributeName, String uuid) {
        if (doc == null) {
            return null;
        }
        return XMLUtils.findElementByUUID(doc.getDocumentElement(), attributeName, uuid);
    }
}

