/*
 * Decompiled with CFR 0.152.
 */
package stream;

import backtype.storm.Config;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.DocumentEncoder;
import stream.io.TimeStream;
import stream.storm.ClockSpout;
import stream.storm.MonitorBolt;
import stream.storm.ProcessBolt;
import stream.storm.StreamSpout;
import stream.util.XMLUtils;
import stream.util.parser.TimeParser;

public class StreamTopology {
    public static final String UUID_ATTRIBUTE = "stream.storm.uuid";
    static Logger log = LoggerFactory.getLogger(StreamTopology.class);

    public static TopologyBuilder build(Document doc, TopologyBuilder builder) throws Exception {
        doc = XMLUtils.addUUIDAttributes((Document)doc, (String)UUID_ATTRIBUTE);
        String xml = XMLUtils.toString((Document)doc);
        LinkedHashMap streams = new LinkedHashMap();
        NodeList list = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            log.info(node.getNodeName());
            Element el = (Element)node;
            String uuid = el.getAttribute(UUID_ATTRIBUTE);
            if (el.getNodeName().equalsIgnoreCase("stream")) {
                String id = el.getAttribute("id");
                log.info("Creating stream-spout for id {}", (Object)id);
                builder.setSpout(id, (IRichSpout)new StreamSpout(xml, uuid));
                continue;
            }
            if (el.getNodeName().equalsIgnoreCase("process")) {
                String input = el.getAttribute("input");
                String copies = el.getAttribute("copies");
                Integer workers = 1;
                if (copies != null) {
                    // empty if block
                }
                log.info("Adding bolt {}, subscribing to {}", (Object)uuid, (Object)input);
                builder.setBolt(uuid, (IRichBolt)new ProcessBolt(xml, uuid), (Number)workers).shuffleGrouping(input);
            }
            if (!el.getNodeName().equalsIgnoreCase("monitor")) continue;
            String clock = "clock:" + UUID.randomUUID().toString();
            String interval = el.getAttribute("interval");
            TimeStream timeStream = new TimeStream();
            timeStream.setInterval(interval);
            ClockSpout spout = new ClockSpout(TimeParser.parseTime((String)interval));
            builder.setSpout(clock, (IRichSpout)spout);
            builder.setBolt(uuid, (IRichBolt)new MonitorBolt(xml, uuid)).shuffleGrouping(clock);
        }
        return builder;
    }

    public static StormTopology createTopology(Document doc) throws Exception {
        TopologyBuilder builder = StreamTopology.build(doc, new TopologyBuilder());
        StormTopology topology = builder.createTopology();
        return topology;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Missing XML definition (base64 encoded)!");
            return;
        }
        Document doc = DocumentEncoder.decodeDocument(args[0]);
        Config conf = new Config();
        conf.setNumWorkers(20);
        TopologyBuilder builder = StreamTopology.build(doc, new TopologyBuilder());
        StormTopology topology = builder.createTopology();
        StormSubmitter.submitTopology((String)"test", (Map)conf, (StormTopology)topology);
    }
}

