/*
 * Decompiled with CFR 0.152.
 */
package stream;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.DefaultNamingService;
import stream.runtime.StreamRuntime;
import stream.shell.Call;
import stream.shell.Command;
import stream.shell.Discover;
import stream.shell.Info;
import stream.shell.List;
import stream.shell.Shutdown;

public class Shell {
    static Logger log = LoggerFactory.getLogger(Shell.class);
    static final String VERSION = "0.01";
    final String prompt = "streams> ";
    final DefaultNamingService namingService = new DefaultNamingService();
    final Map<String, String> env = new LinkedHashMap<String, String>();
    final Map<String, Command> commands = new LinkedHashMap<String, Command>();

    public Shell() throws Exception {
        this.commands.put("discover", new Discover(this));
        this.commands.put("shutdown", new Shutdown(this));
        this.commands.put("info", new Info(this));
        this.commands.put("call", new Call(this));
        this.commands.put("list", new List(this));
        this.commands.put("environment", new Environment(this));
        this.commands.put("version", new Version(this));
    }

    public String eval(String line) throws Exception {
        log.info("Executing {}", (Object)line);
        if ("help".equalsIgnoreCase(line.trim())) {
            System.out.println("  Available commands:\n");
            for (String key : this.commands.keySet()) {
                System.out.println("    " + key);
            }
            return "\n";
        }
        for (String key : this.env.keySet()) {
            if (!key.startsWith("#")) continue;
            line = line.replace(key, this.env.get(key));
        }
        log.info("After replacement: {}", (Object)line);
        for (String key : this.commands.keySet()) {
            String[] args;
            if (!key.equalsIgnoreCase((args = line.split("\\s+", 2))[0]) && !key.startsWith(args[0])) continue;
            log.info("Found command {}", (Object)this.commands.get(key));
            String[] params = new String[]{};
            if (args.length > 1) {
                params = args[1].split("\\s+");
            }
            System.out.println();
            return this.commands.get(key).execute(params);
        }
        log.info("No command found for '{}'", (Object)line);
        return "";
    }

    public String call(String name, String method, String ... args) {
        Serializable[] params = new Serializable[args.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = args[i];
        }
        return "";
    }

    public void repl(InputStream in, OutputStream out) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        PrintWriter writer = new PrintWriter(out);
        writer.print("streams> ");
        writer.flush();
        String line = reader.readLine();
        while (line != null && !(line = line.trim()).equalsIgnoreCase("quit") && !line.equalsIgnoreCase("exit")) {
            String output = this.eval(line);
            writer.println(output);
            writer.print("streams> ");
            writer.flush();
            line = reader.readLine();
        }
        reader.close();
        writer.close();
    }

    public DefaultNamingService getNamingService() {
        return this.namingService;
    }

    public void set(String key, String value) {
        this.env.put(key, value);
    }

    public String get(String key) {
        return this.env.get(key);
    }

    public static void main(String[] args) throws Exception {
        StreamRuntime.setupLogging();
        int port = 9105;
        String host = "192.168.10.2";
        if (args.length > 1) {
            host = args[0];
            port = new Integer(args[1]);
        }
        System.out.println("  java.rmi.server.codebase = " + System.getProperty("java.rmi.server.codebase"));
        System.out.println("connecting to " + host + ":" + port + "...");
        Shell shell = new Shell();
        shell.repl(System.in, System.out);
    }

    public final class Version
    extends Command {
        public Version(Shell shell2) {
            super(shell2);
        }

        @Override
        public String execute(String[] args) {
            this.println("stream.Shell - Version 0.01");
            return "";
        }
    }

    public final class Environment
    extends Command {
        public Environment(Shell shell2) {
            super(shell2);
        }

        @Override
        public String execute(String[] args) {
            this.println("Environment:");
            this.println("------------");
            for (String key : Shell.this.env.keySet()) {
                this.println("  " + key + "  =>  " + Shell.this.env.get(key));
            }
            this.println("");
            return "";
        }
    }
}

