/*
 * Decompiled with CFR 0.152.
 */
package stream;

import backtype.storm.Config;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.topology.TopologyBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.DocumentEncoder;
import stream.io.TimeStream;
import stream.storm.ClockSpout;
import stream.storm.MonitorBolt;
import stream.storm.ProcessBolt;
import stream.storm.StreamSpout;
import stream.util.XMLUtils;
import stream.util.parser.TimeParser;

public class StreamTopology {
    public static final String UUID_ATTRIBUTE = "stream.storm.uuid";
    static Logger log = LoggerFactory.getLogger(StreamTopology.class);
    final TopologyBuilder builder;
    final Map<String, BoltDeclarer> bolts = new LinkedHashMap<String, BoltDeclarer>();
    final Map<String, SpoutDeclarer> spouts = new LinkedHashMap<String, SpoutDeclarer>();

    private StreamTopology(TopologyBuilder builder) {
        this.builder = builder;
    }

    public TopologyBuilder getTopologyBuilder() {
        return this.builder;
    }

    public Map<String, BoltDeclarer> getBolts() {
        return Collections.unmodifiableMap(this.bolts);
    }

    public Map<String, SpoutDeclarer> getSpouts() {
        return Collections.unmodifiableMap(this.spouts);
    }

    public static StreamTopology create(Document doc) throws Exception {
        return StreamTopology.build(doc, new TopologyBuilder());
    }

    public static StreamTopology build(Document doc, TopologyBuilder builder) throws Exception {
        StreamTopology st = new StreamTopology(builder);
        doc = XMLUtils.addUUIDAttributes(doc, UUID_ATTRIBUTE);
        String xml = XMLUtils.toString(doc);
        NodeList list = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            log.info(node.getNodeName());
            Element el = (Element)node;
            String uuid = el.getAttribute(UUID_ATTRIBUTE);
            if (el.getNodeName().equalsIgnoreCase("stream")) {
                String id = el.getAttribute("id");
                log.info("Creating stream-spout for id {}", (Object)id);
                StreamSpout spout = new StreamSpout(xml, uuid);
                SpoutDeclarer spoutDeclarer = builder.setSpout(id, (IRichSpout)spout);
                st.spouts.put(id, spoutDeclarer);
                continue;
            }
            if (el.getNodeName().equalsIgnoreCase("process")) {
                String input = el.getAttribute("input");
                String copies = el.getAttribute("copies");
                Integer workers = 1;
                if (copies != null) {
                    // empty if block
                }
                log.info("Adding bolt {}, subscribing to {}", (Object)uuid, (Object)input);
                ProcessBolt bolt = new ProcessBolt(xml, uuid);
                BoltDeclarer boltDeclarer = (BoltDeclarer)builder.setBolt(uuid, (IRichBolt)bolt, (Number)workers).shuffleGrouping(input);
                st.bolts.put(uuid, boltDeclarer);
                continue;
            }
            if (!el.getNodeName().equalsIgnoreCase("monitor")) continue;
            String clock = "clock:" + UUID.randomUUID().toString();
            String interval = el.getAttribute("interval");
            TimeStream timeStream = new TimeStream();
            timeStream.setInterval(interval);
            ClockSpout spout = new ClockSpout(TimeParser.parseTime(interval));
            builder.setSpout(clock, (IRichSpout)spout);
            builder.setBolt(uuid, (IRichBolt)new MonitorBolt(xml, uuid)).shuffleGrouping(clock);
        }
        return st;
    }

    public StormTopology createTopology() {
        return this.builder.createTopology();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Missing XML definition (base64 encoded)!");
            return;
        }
        Document doc = DocumentEncoder.decodeDocument(args[0]);
        Config conf = new Config();
        conf.setNumWorkers(20);
        StreamTopology streamTop = StreamTopology.build(doc, new TopologyBuilder());
        StormTopology topology = streamTop.getTopologyBuilder().createTopology();
        StormSubmitter.submitTopology((String)"test", (Map)conf, (StormTopology)topology);
    }
}

