/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Description;

@Description(group="Data Stream.Processing.Transformations.Data")
public class BinaryLabels
extends AbstractProcessor {
    String labelAttribute;
    String positive = null;
    Double threshold = null;

    public BinaryLabels() {
        this(null, null);
    }

    public BinaryLabels(String label) {
        this(label, null);
    }

    public BinaryLabels(String label, String positive) {
        this.labelAttribute = label;
        this.positive = positive;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public String getLabel() {
        return this.labelAttribute;
    }

    public void setLabel(String key) {
        this.labelAttribute = key;
    }

    public String getPositive() {
        return this.positive;
    }

    public void setPositive(String positive) {
        this.positive = positive;
    }

    @Override
    public Data process(Data data) {
        if (this.labelAttribute == null) {
            for (String k : data.keySet()) {
                if (!k.startsWith("@label")) continue;
                this.labelAttribute = k;
                break;
            }
        }
        if (this.labelAttribute == null) {
            return data;
        }
        Serializable val = (Serializable)data.get(this.labelAttribute);
        if (val == null) {
            return data;
        }
        if (val instanceof Double) {
            Double d;
            if (this.threshold == null) {
                this.threshold = 0.0;
            }
            if ((d = (Double)val) < this.threshold) {
                data.put(this.labelAttribute, -1.0);
            } else {
                data.put(this.labelAttribute, 1.0);
            }
            return data;
        }
        if (this.positive == null) {
            this.positive = val.toString();
        }
        if (this.positive.equals(val)) {
            data.put(this.labelAttribute, 1.0);
        } else {
            data.put(this.labelAttribute, -1.0);
        }
        return data;
    }
}

