/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;

public class Conventions {
    public static Key createKey(String name) {
        if (!Conventions.isAnnotated(name)) {
            return new Key(null, name);
        }
        int idx = name.indexOf(":");
        if (idx > 0 && name.length() > idx) {
            return new Key(name.substring(1, idx), name.substring(idx + 1));
        }
        return new Key(name.substring(1), name.substring(1));
    }

    public static Key createKey(String annotation, String name) {
        return new Key(annotation, name);
    }

    public static boolean isAnnotated(String name) {
        return name != null && name.startsWith("@");
    }

    public static final class Key
    implements Serializable {
        private static final long serialVersionUID = -4855161867291167265L;
        public final String name;
        public final String annotation;

        private Key(String annotation, String name) {
            this.annotation = annotation != null ? annotation.trim() : null;
            this.name = name;
        }

        public String toString() {
            if (this.annotation == null) {
                return this.name;
            }
            StringBuilder s = new StringBuilder();
            if (this.annotation != null) {
                s.append("@");
                s.append(this.annotation);
            }
            if (this.name != null && !this.name.equals("")) {
                if (this.annotation != null) {
                    s.append(":");
                }
                s.append(this.name);
            }
            return s.toString();
        }

        public int hashCode() {
            return (this.name + this.annotation).hashCode();
        }
    }
}

