/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import stream.Data;
import stream.Measurable;
import stream.util.SizeOf;

public class DataImpl
extends LinkedHashMap<String, Serializable>
implements Data,
Measurable {
    private static final long serialVersionUID = -7751681008628413236L;

    public DataImpl() {
    }

    public DataImpl(Map<String, Serializable> data) {
        super(data);
    }

    @Override
    public double getByteSize() {
        double size = 0.0;
        for (String key : this.keySet()) {
            size += (double)(key.length() + 1);
            Serializable value = (Serializable)this.get(key);
            size += SizeOf.sizeOf((Object)value);
        }
        return size;
    }

    @Override
    public Data createCopy() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Data copy = (Data)ois.readObject();
            ois.close();
            return copy;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create-copy of item due to: '" + e.getMessage() + "'");
        }
    }
}

