/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ConditionedProcessor;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;

@Description(name="Rename Key", text="", group="Data Stream.Processing.Transformations.Attributes")
public class RenameKey
extends ConditionedProcessor {
    static Logger log = LoggerFactory.getLogger(RenameKey.class);
    String oldKey;
    String newKey;

    public RenameKey(String oldKey, String newKey) {
        this.oldKey = oldKey;
        this.newKey = newKey;
    }

    public RenameKey() {
        this.oldKey = "";
        this.newKey = "";
    }

    public String getFrom() {
        return this.oldKey;
    }

    @Parameter(required=true, description="The old name of the key.")
    public void setFrom(String oldKey) {
        this.oldKey = oldKey;
    }

    public String getTo() {
        return this.newKey;
    }

    @Parameter(required=true, description="The new name of the key.")
    public void setTo(String newKey) {
        this.newKey = newKey;
    }

    @Override
    public Data processMatchingData(Data input) {
        if (this.oldKey != null && this.newKey != null && input.containsKey(this.oldKey)) {
            if (input.containsKey(this.newKey)) {
                log.warn("Overwriting existing key '{}'!", (Object)this.newKey);
            }
            Serializable o = (Serializable)input.remove(this.oldKey);
            input.put(this.newKey, o);
        }
        return input;
    }
}

