/*
 * Decompiled with CFR 0.152.
 */
package stream.data.tree;

import java.io.Serializable;
import java.util.Collection;
import stream.data.TreeNode;
import stream.data.tree.AbstractTreeFeature;

public class CountLeaves
extends AbstractTreeFeature {
    @Override
    public String createFeatureKey(String inputKey) {
        return "leafCount(" + inputKey + ")";
    }

    @Override
    public Serializable compute(TreeNode tree) {
        return this.getNumberOfLeaves(tree);
    }

    public Integer getNumberOfLeaves(TreeNode tree) {
        if (tree.isLeaf()) {
            return 1;
        }
        Integer sum = 0;
        for (TreeNode ch : tree.children()) {
            sum = sum + this.getNumberOfLeaves(ch);
        }
        return sum;
    }

    protected Integer max(Collection<Integer> input) {
        Integer max = null;
        for (Integer i : input) {
            if (max != null && i <= max) continue;
            max = i;
        }
        return max;
    }
}

