/*
 * Decompiled with CFR 0.152.
 */
package stream.data.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import stream.data.TreeNode;
import stream.data.tree.AbstractTreeFeature;

public class Height
extends AbstractTreeFeature {
    @Override
    public String createFeatureKey(String inputKey) {
        return "height(" + inputKey + ")";
    }

    @Override
    public Serializable compute(TreeNode tree) {
        return this.getHeight(tree);
    }

    public Integer getHeight(TreeNode tree) {
        if (tree.isLeaf()) {
            return 0;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (TreeNode ch : tree.children()) {
            list.add(this.getHeight(ch));
        }
        return 1 + this.max(list);
    }

    public Integer getNumberOfNodes(TreeNode tree) {
        if (tree.isLeaf()) {
            return 1;
        }
        Integer sum = 1;
        for (TreeNode ch : tree.children()) {
            sum = sum + this.getNumberOfNodes(ch);
        }
        return sum;
    }

    public Integer getNumberOfLeaves(TreeNode tree) {
        if (tree.isLeaf()) {
            return 1;
        }
        Integer sum = 0;
        for (TreeNode ch : tree.children()) {
            sum = sum + this.getNumberOfLeaves(ch);
        }
        return sum;
    }

    protected Integer max(Collection<Integer> input) {
        Integer max = null;
        for (Integer i : input) {
            if (max != null && i <= max) continue;
            max = i;
        }
        return max;
    }
}

