/*
 * Decompiled with CFR 0.152.
 */
package stream.data.vector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import stream.Data;
import stream.Measurable;
import stream.data.DataUtils;
import stream.data.vector.InputVector;

public class Vector
implements Serializable,
Measurable {
    private static final long serialVersionUID = -5547469461526949533L;
    Type type;
    double scale = 1.0;
    double snorm = 0.0;
    HashMap<Integer, Double> pairs;
    int max_index = -1;
    double[] vals;
    int length = -1;

    public Type getType() {
        return this.type;
    }

    public boolean isSparse() {
        return this.type == Type.SPARSE;
    }

    public HashMap<Integer, Double> getPairs() {
        return this.pairs;
    }

    public Vector() {
        this.type = Type.SPARSE;
        this.pairs = new HashMap();
        this.max_index = 0;
    }

    public Vector(int length) {
        this.type = Type.DENSE;
        this.length = length;
        this.vals = new double[length];
    }

    public Vector(int[] index, double[] vals) {
        this.type = Type.SPARSE;
        this.length = index.length;
        this.pairs = new HashMap();
        for (int i = 0; i < this.length; ++i) {
            this.pairs.put(index[i], vals[i]);
            this.snorm += vals[i] * vals[i];
            if (index[i] <= this.max_index) continue;
            this.max_index = index[i];
        }
    }

    public Vector(double[] vals) {
        this(vals, true);
    }

    public Vector(double[] vals, boolean copy) {
        this.type = Type.DENSE;
        this.length = vals.length;
        if (!copy) {
            this.vals = vals;
            for (int i = 0; i < this.length; ++i) {
                this.snorm += vals[i] * vals[i];
            }
        } else {
            this.vals = new double[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.vals[i] = vals[i];
                this.snorm += vals[i] * vals[i];
            }
        }
    }

    public Vector(HashMap<Integer, Double> pairs) {
        this(pairs, true);
    }

    public Vector(HashMap<Integer, Double> pairs, boolean copy) {
        this.type = Type.SPARSE;
        if (!copy) {
            this.pairs = pairs;
            for (Map.Entry<Integer, Double> entry : pairs.entrySet()) {
                int idx = entry.getKey();
                double val = entry.getValue();
                this.snorm += val * val;
                if (idx <= this.max_index) continue;
                this.max_index = idx;
            }
        } else {
            this.pairs = new HashMap();
            for (Map.Entry<Integer, Double> entry : pairs.entrySet()) {
                int idx = entry.getKey();
                double val = entry.getValue();
                this.snorm += val * val;
                if (idx > this.max_index) {
                    this.max_index = idx;
                }
                this.pairs.put(idx, val);
            }
        }
    }

    public Vector(Vector x) {
        this.type = x.type;
        if (x.type == Type.DENSE) {
            this.length = x.length;
            this.vals = new double[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.vals[i] = x.vals[i];
                this.snorm += this.vals[i] * this.vals[i];
            }
        } else {
            this.pairs = new HashMap();
            for (Map.Entry<Integer, Double> xentry : x.getPairs().entrySet()) {
                int idx = xentry.getKey();
                double val = xentry.getValue();
                this.snorm += val * val;
                if (idx > this.max_index) {
                    this.max_index = idx;
                }
                this.pairs.put(idx, val);
            }
        }
    }

    public Vector(int[] index, double[] vals, int length) {
        this.type = Type.DENSE;
        this.length = length;
        this.vals = new double[length];
        for (int i = 0; i < index.length; ++i) {
            int idx = index[i];
            this.vals[idx] = vals[i];
            this.snorm += vals[i] * vals[i];
        }
    }

    public int length() {
        if (this.type == Type.SPARSE) {
            return this.max_index + 1;
        }
        return this.length;
    }

    public void set(int j, double d) {
        double val = d / this.scale;
        if (this.type == Type.SPARSE) {
            Double my_val = this.pairs.get(j);
            if (my_val != null) {
                this.snorm -= my_val * my_val;
            }
            this.snorm += val * val;
            this.pairs.put(j, val);
            if (j > this.max_index) {
                this.max_index = j;
            }
        } else {
            if (j < this.length) {
                Double my_val = this.vals[j];
                this.snorm += -my_val.doubleValue() * my_val + val * val;
            }
            this.snorm += val * val;
            this.vals[j] = val;
        }
    }

    public double get(int i) {
        if (this.type == Type.SPARSE) {
            return this.scale * this.pairs.get(i);
        }
        return this.scale * this.vals[i];
    }

    public Vector scale(double s) {
        this.snorm *= s * s;
        if (s != 0.0) {
            this.scale *= s;
        } else {
            this.scale = 1.0;
            if (this.type == Type.SPARSE) {
                for (Map.Entry<Integer, Double> entry : this.pairs.entrySet()) {
                    entry.setValue(0.0);
                }
            } else {
                for (int i = 0; i < this.length; ++i) {
                    this.vals[i] = 0.0;
                }
            }
        }
        return this;
    }

    public Vector add(Vector x) {
        return this.add(1.0, x);
    }

    public Vector add(double factor, Vector x) {
        double xterm = 0.0;
        double snorm_x = 0.0;
        if (this.type == Type.SPARSE && x.type == Type.SPARSE) {
            for (Map.Entry<Integer, Double> entry : x.pairs.entrySet()) {
                Integer idx = entry.getKey();
                Double x_val = factor * x.scale * entry.getValue();
                snorm_x += x_val * x_val;
                Double my_val = this.pairs.get(idx);
                if (my_val != null) {
                    xterm += 2.0 * my_val * x_val;
                    this.pairs.put(idx, my_val + x_val / this.scale);
                } else {
                    this.pairs.put(idx, x_val / this.scale);
                }
                if (idx <= this.max_index) continue;
                this.max_index = idx;
            }
        } else if (this.type == Type.DENSE && x.type == Type.SPARSE) {
            for (Map.Entry<Integer, Double> entry : x.pairs.entrySet()) {
                Integer idx = entry.getKey();
                Double x_val = factor * x.scale * entry.getValue();
                snorm_x += x_val * x_val;
                double my_val = this.vals[idx];
                xterm += 2.0 * my_val * x_val;
                this.vals[idx.intValue()] = my_val + x_val / this.scale;
            }
        } else if (this.type == Type.SPARSE && x.type == Type.DENSE) {
            for (int i = 0; i < x.length; ++i) {
                double x_val = factor * x.scale * x.vals[i];
                snorm_x += x_val * x_val;
                Double my_val = this.pairs.get(i);
                if (my_val != null) {
                    xterm += 2.0 * my_val * x_val;
                    this.pairs.put(i, my_val + x_val / this.scale);
                    continue;
                }
                this.pairs.put(i, x_val / this.scale);
            }
            this.max_index = x.length - 1;
        } else {
            for (int i = 0; i < x.length; ++i) {
                double x_val = factor * x.scale * x.vals[i];
                snorm_x += x_val * x_val;
                double my_val = this.vals[i];
                xterm += 2.0 * my_val * x_val;
                this.vals[i] = my_val + x_val / this.scale;
            }
        }
        this.snorm += snorm_x + this.scale * xterm;
        return this;
    }

    public double norm() {
        return Math.sqrt(this.snorm());
    }

    public double snorm() {
        return this.snorm;
    }

    public double innerProduct(Vector x) {
        double sum = 0.0;
        if (this.type == Type.SPARSE && x.type == Type.SPARSE) {
            for (Map.Entry<Integer, Double> entry : x.pairs.entrySet()) {
                Integer idx = entry.getKey();
                Double x_val = entry.getValue();
                Double my_val = this.pairs.get(idx);
                if (my_val == null) continue;
                sum += my_val * x_val;
            }
        } else if (this.type == Type.DENSE && x.type == Type.SPARSE) {
            for (Map.Entry<Integer, Double> entry : x.pairs.entrySet()) {
                Integer idx = entry.getKey();
                Double x_val = entry.getValue();
                double my_val = this.vals[idx];
                sum += my_val * x_val;
            }
        } else if (this.type == Type.SPARSE && x.type == Type.DENSE) {
            for (Map.Entry<Integer, Double> entry : this.pairs.entrySet()) {
                Integer idx = entry.getKey();
                Double my_val = entry.getValue();
                double x_val = x.vals[idx];
                sum += my_val * x_val;
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                sum += this.vals[i] * x.vals[i];
            }
        }
        return sum *= this.scale * x.scale;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.type == Type.SPARSE) {
            for (Map.Entry<Integer, Double> entry : this.pairs.entrySet()) {
                if (!(entry.getValue() > 0.0)) continue;
                s.append(" ");
                s.append(entry.getKey());
                s.append(":");
                s.append(this.scale * entry.getValue());
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.vals[i] > 0.0)) continue;
                s.append(" ");
                s.append(i);
                s.append(":");
                s.append(this.scale * this.vals[i]);
            }
        }
        return s.toString();
    }

    @Override
    public double getByteSize() {
        double size = (double)this.pairs.size() * 16.0;
        size += 8.0;
        return size += 8.0;
    }

    public static Vector createSparseVector(Data datum) {
        if (datum.containsKey("@__sparse-vector")) {
            return (InputVector)datum.get("@__sparse-vector");
        }
        for (Serializable val : datum.values()) {
            if (!(val instanceof InputVector)) continue;
            return (InputVector)val;
        }
        TreeSet<String> indexes = new TreeSet<String>();
        for (String key : datum.keySet()) {
            Serializable val = (Serializable)datum.get(key);
            if (DataUtils.isAnnotation(key) || !key.matches("\\d+") || !Number.class.isAssignableFrom(val.getClass())) continue;
            indexes.add(key);
        }
        double y = Double.NaN;
        if (datum.containsKey("@label")) {
            try {
                y = (Double)datum.get("@label");
            }
            catch (Exception e) {
                y = Double.NaN;
            }
        }
        HashMap<Integer, Double> pairs = new HashMap<Integer, Double>();
        for (String key : indexes) {
            pairs.put(Integer.parseInt(key), (Double)datum.get(key));
        }
        InputVector vec = new InputVector(pairs, false, y);
        return vec;
    }

    public static enum Type {
        DENSE,
        SPARSE;

    }
}

