/*
 * Decompiled with CFR 0.152.
 */
package stream.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.expressions.BooleanOperator;
import stream.expressions.Expression;
import stream.expressions.ExpressionException;
import stream.expressions.ExpressionList;
import stream.expressions.Match;
import stream.expressions.Operator;

public class ExpressionReader {
    int pos = 0;
    String input;
    Set<Operator> supportedOperators = new HashSet<Operator>();
    Set<BooleanOperator> supportedBoolOperators = new HashSet<BooleanOperator>();
    Set<String> supportedVariables = null;
    public static final boolean STRICT_PARSING = "true".equalsIgnoreCase("" + System.getProperty("event.filter.strict"));
    static Logger log = LoggerFactory.getLogger(ExpressionReader.class);
    boolean strictParsing = STRICT_PARSING;

    protected ExpressionReader(String str) {
        this.input = str;
        this.pos = 0;
        this.supportedBoolOperators.add(BooleanOperator.AND);
        this.supportedBoolOperators.add(BooleanOperator.OR);
        for (Operator op : Operator.OPERATORS.values()) {
            this.supportedOperators.add(op);
        }
    }

    protected ExpressionReader(String str, Collection<String> variables) {
        this(str);
        this.supportedVariables = new HashSet<String>();
        for (String var : variables) {
            this.supportedVariables.add(var.toUpperCase());
        }
    }

    protected ExpressionReader(String str, Collection<String> variables, Set<Operator> operators) {
        this(str, variables);
        this.supportedOperators.clear();
        this.supportedOperators.addAll(operators);
    }

    public boolean isStrictParsing() {
        return this.strictParsing;
    }

    public void setStrictParsing(boolean strictParsing) {
        this.strictParsing = strictParsing;
    }

    public void setBooleanOperators(Set<BooleanOperator> booleanOps) {
        this.supportedBoolOperators = new HashSet<BooleanOperator>(booleanOps);
    }

    public Set<BooleanOperator> getBooleanOperators() {
        return this.supportedBoolOperators;
    }

    protected Expression readFilterExpression() throws ExpressionException {
        this.skipWhiteSpace();
        Expression first = this.startsWith("(") ? this.readNestedExpression() : this.readSimpleFilter();
        if (!(this.endOfLine() || this.hasBooleanOperator() || this.startsWith(")"))) {
            throw new ExpressionException("Boolean operator 'AND' or 'OR' expected after '" + this.input.substring(0, this.pos) + "'!");
        }
        if (this.endOfLine()) {
            return first;
        }
        log.debug("remainder: {}", (Object)this.input.substring(this.pos));
        ArrayList<Expression> exps = new ArrayList<Expression>();
        ArrayList<BooleanOperator> ops = new ArrayList<BooleanOperator>();
        exps.add(first);
        while (!this.endOfLine() && this.hasBooleanOperator()) {
            ops.add(this.readBooleanOperator());
            if (this.startsWith("(")) {
                exps.add(this.readNestedExpression());
                continue;
            }
            exps.add(this.readSimpleFilter());
        }
        log.debug("Ops: {}", (Object)ops);
        log.debug("Exps: {}", (Object)exps);
        if (exps.size() == 1) {
            return first;
        }
        return new ExpressionList((BooleanOperator)((Object)ops.iterator().next()), (Collection<Expression>)exps);
    }

    public boolean endOfLine() {
        return this.pos >= this.input.length() || this.input.substring(this.pos).trim().equals("");
    }

    public ExpressionList readNestedExpression() throws ExpressionException {
        if (!this.startsWith("(")) {
            throw new ExpressionException("No start of nested expression found!");
        }
        this.skipWhiteSpace();
        ++this.pos;
        ArrayList<Expression> exp = new ArrayList<Expression>();
        exp.add(this.readFilterExpression());
        BooleanOperator op = BooleanOperator.AND;
        while (!this.startsWith(")")) {
            if (this.endOfLine()) {
                throw new ExpressionException("Unexpected end of expression! Missing a closing bracket?");
            }
            op = this.readBooleanOperator();
            if (this.startsWith("(")) {
                exp.add(this.readNestedExpression());
                continue;
            }
            exp.add(this.readFilterExpression());
        }
        this.skipWhiteSpace();
        ++this.pos;
        return new ExpressionList(op, (Collection<Expression>)exp);
    }

    public boolean startsWith(String str) {
        int i;
        for (i = this.pos; i < this.input.length() && Character.isWhitespace(this.input.charAt(i)); ++i) {
        }
        if (i >= this.input.length()) {
            return false;
        }
        return this.input.substring(i).startsWith(str);
    }

    public Expression readSimpleFilter() throws ExpressionException {
        try {
            String left = this.readVariable();
            Operator op = this.readOperator();
            String right = this.readValue();
            return new Match(left, op, right);
        }
        catch (ExpressionException se) {
            throw new ExpressionException(se.getMessage());
        }
    }

    protected boolean hasBooleanOperator() {
        int i;
        for (i = this.pos; i < this.input.length() && Character.isWhitespace(this.input.charAt(i)); ++i) {
        }
        if (i >= this.input.length()) {
            return false;
        }
        String rest = this.input.substring(i);
        return rest.toLowerCase().startsWith("or ") || rest.toLowerCase().startsWith("and ");
    }

    protected BooleanOperator readBooleanOperator() throws ExpressionException {
        this.skipWhiteSpace();
        StringBuffer var = new StringBuffer();
        this.skipWhiteSpace();
        while (this.pos < this.input.length() && !Character.isWhitespace(this.input.charAt(this.pos))) {
            var.append(this.input.charAt(this.pos++));
        }
        String operatorName = var.toString();
        BooleanOperator op = BooleanOperator.read(operatorName);
        if (!this.supportedBoolOperators.contains((Object)op)) {
            if (this.isStrictParsing()) {
                throw new ExpressionException("Boolean operator '" + operatorName + "' is not supported!");
            }
            log.warn("Boolean operator '{}' is not supported, but 'strictParsing' is disabled!", (Object)operatorName);
        }
        return op;
    }

    public int getPosition() {
        return this.pos;
    }

    public String getInputString() {
        return this.input;
    }

    protected void skipWhiteSpace() {
        while (this.pos < this.input.length() && Character.isWhitespace(this.input.charAt(this.pos))) {
            ++this.pos;
        }
    }

    protected String readVariable() throws ExpressionException {
        StringBuffer var = new StringBuffer();
        this.skipWhiteSpace();
        while (this.pos < this.input.length() && !Character.isWhitespace(this.input.charAt(this.pos))) {
            var.append(this.input.charAt(this.pos++));
        }
        String variable = var.toString();
        if (this.supportedVariables != null && !this.supportedVariables.contains(variable.toUpperCase())) {
            if (this.isStrictParsing()) {
                throw new ExpressionException("Not a valid variable name '" + variable + "'!");
            }
            log.warn("Found variable '{}' which has not been defined previously!", (Object)variable);
        }
        return variable;
    }

    protected Operator readOperator() throws ExpressionException {
        this.skipWhiteSpace();
        if (this.pos >= this.input.length()) {
            throw new ExpressionException("Operator expected at position " + this.pos + ", found: '" + this.input.substring(this.pos) + "'!");
        }
        StringBuffer buf = new StringBuffer();
        while (this.pos < this.input.length() && !Character.isWhitespace(this.input.charAt(this.pos))) {
            buf.append(this.input.charAt(this.pos++));
        }
        Operator op = Operator.read(buf.toString());
        if (!this.supportedOperators.contains(op)) {
            if (this.isStrictParsing()) {
                throw new ExpressionException("Operator '" + op.toString() + "' not supported!");
            }
            log.warn("Operator '{}' is not supported, but 'strictParsing' disabled!", (Object)op);
        }
        return op;
    }

    protected String readValue() throws ExpressionException {
        StringBuffer var = new StringBuffer();
        this.skipWhiteSpace();
        if (this.endOfLine() || this.startsWith(")") || this.hasBooleanOperator()) {
            throw new ExpressionException("Value expected at position " + this.pos + "!");
        }
        if (this.input.charAt(this.pos) == '\"' || this.input.charAt(this.pos) == '\'') {
            return this.readQuotedString(this.input.charAt(this.pos));
        }
        while (this.pos < this.input.length() && this.input.charAt(this.pos) != ')' && !Character.isWhitespace(this.input.charAt(this.pos))) {
            var.append(this.input.charAt(this.pos++));
        }
        return var.toString();
    }

    protected String readQuotedString(char ch) {
        StringBuffer s = new StringBuffer();
        while (this.pos < this.input.length() && ch != this.input.charAt(this.pos)) {
            ++this.pos;
        }
        ++this.pos;
        if (this.pos < this.input.length()) {
            s.append(this.input.charAt(this.pos++));
        }
        int last = 32;
        while (this.pos < this.input.length() && last != 92 && ch != this.input.charAt(this.pos)) {
            char cur = this.input.charAt(this.pos++);
            s.append(cur);
            last = cur;
        }
        ++this.pos;
        return s.toString();
    }

    public static final Expression parse(String str) throws ExpressionException {
        log.debug("Parsing expression: {}", (Object)str);
        ExpressionReader r = new ExpressionReader(str);
        return r.readFilterExpression();
    }
}

