/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Parameter;
import stream.data.DataFactory;

public class Collect
implements Processor {
    static Logger log = LoggerFactory.getLogger(Collect.class);
    String key = "@items";
    Integer count = 1;
    List<Data> items = new ArrayList<Data>();

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The key (name) of the attribute into which the collection (array) of items will be put, defaults to '@items'")
    public void setKey(String key) {
        this.key = key;
    }

    public Integer getCount() {
        return this.count;
    }

    @Parameter(description="The number of items that should be collected before the processing continues.", required=true, min=0.0)
    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public Data process(Data input) {
        if (this.items.size() < this.count) {
            log.debug("Collecting next item, {} already collected.", (Object)this.items.size());
            this.items.add(DataFactory.create(input));
            return null;
        }
        log.debug("Finished with my collection, emitting the item-array in a new item.");
        Data[] vals = new Data[this.items.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = this.items.get(i);
        }
        Data collection = DataFactory.create();
        collection.put(this.key, vals);
        this.items.clear();
        return collection;
    }
}

