/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ConditionedProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.util.parser.TimeParser;

@Description(group="Streams.Flow")
public class Delay
extends ConditionedProcessor {
    static Logger log = LoggerFactory.getLogger(Delay.class);
    Long milliseconds = 0L;
    String time = "1000ms";

    public String getTime() {
        return this.time;
    }

    @Parameter(required=true, defaultValue="1000ms")
    public void setTime(String time) {
        this.time = time;
    }

    @Override
    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.milliseconds = this.time != null && !"".equals(this.time.trim()) ? TimeParser.parseTime(this.time) : Long.valueOf(0L);
    }

    @Override
    public Data processMatchingData(Data data) {
        if (this.milliseconds > 0L) {
            try {
                Thread.sleep(this.milliseconds);
            }
            catch (Exception e) {
                log.error("Failed to delay execution: {}", (Object)e.getMessage());
            }
        }
        return data;
    }
}

