/*
 * Decompiled with CFR 0.152.
 */
package stream.flow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ConditionedProcessor;
import stream.Data;
import stream.io.QueueService;

public class Redirect
extends ConditionedProcessor {
    static Logger log = LoggerFactory.getLogger(Redirect.class);
    QueueService[] queues;

    public QueueService[] getQueues() {
        return this.queues;
    }

    public void setQueues(QueueService[] queues) {
        this.queues = queues;
    }

    public void setQueue(QueueService queue) {
        this.setQueues(new QueueService[]{queue});
    }

    @Override
    public Data processMatchingData(Data data) {
        if (this.queues == null) {
            return null;
        }
        for (QueueService queue : this.queues) {
            if (queue.enqueue(data)) {
                log.debug("Redirected item to {}", (Object)queue);
                continue;
            }
            log.error("Failed to redirect item to {}", (Object)queue);
        }
        return null;
    }
}

