/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.annotations.Parameter;
import stream.io.sql.DatabaseDialect;
import stream.io.sql.HsqlDialect;
import stream.io.sql.MysqlDialect;

public abstract class AbstractSQLProcessor
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(AbstractSQLProcessor.class);
    protected String url;
    protected String username;
    protected String password;
    protected DatabaseDialect dialect = new MysqlDialect();

    public String getUrl() {
        return this.url;
    }

    @Parameter(required=true, description="The JDBC database url to connect to.")
    public void setUrl(String url) {
        this.url = url;
        if (url.toLowerCase().startsWith("jdbc:mysql")) {
            this.dialect = new MysqlDialect();
        }
        if (url.toLowerCase().startsWith("jdbc:hsqldb")) {
            this.dialect = new HsqlDialect();
        }
    }

    public String getUsername() {
        return this.username;
    }

    @Parameter(required=false, description="The username used to connect to the database.")
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    @Parameter(required=false, description="The password used to connect to the database.")
    public void setPassword(String password) {
        this.password = password;
    }

    protected Connection openConnection() {
        try {
            log.debug("Opening database connection to {}", (Object)this.url);
            Connection con = DriverManager.getConnection(this.url, this.username, this.password);
            log.debug("   connection is: {}", (Object)con);
            return con;
        }
        catch (Exception e) {
            log.error("Failed to open database connection: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected void close(Connection con) {
        block3: {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to close database connection: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    protected boolean createTable(String name, Map<String, Class<?>> types) {
        String create = this.dialect.getCreateTableCommand(name, types);
        log.debug("Trying to create table '{}':\n{}", (Object)name, (Object)create);
        try {
            Connection con = this.openConnection();
            Statement stmt = con.createStatement();
            log.debug("Running create: {}", (Object)create);
            int rc = stmt.executeUpdate(create);
            log.debug("create returned: {}", (Object)rc);
            stmt.close();
            con.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasTable(String name) {
        Statement stmt = null;
        boolean tableExists = false;
        Connection con = null;
        try {
            con = this.openConnection();
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + name);
            if (rs.next()) {
                tableExists = true;
            }
            rs.close();
        }
        catch (Exception e) {
            log.error("Error: {}", (Object)e.getMessage());
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
        this.close(con);
        return tableExists;
    }
}

