/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.AbstractDataStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class CsvStream
extends AbstractDataStream {
    static Logger log = LoggerFactory.getLogger(CsvStream.class);
    String[] keys;
    String splitExpression = "(;|,)";
    LinkedList<String> buffer;

    public CsvStream(SourceURL url) throws Exception {
        super(url);
    }

    public CsvStream(InputStream in) throws Exception {
        super(in);
        this.splitExpression = "(;|,)";
        log.debug("Split expression is: {}", (Object)this.splitExpression);
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public CsvStream(InputStream in, String splitter) throws Exception {
        this(in, Charset.defaultCharset(), splitter);
    }

    public CsvStream(InputStream in, Charset charset, String splitter) throws Exception {
        super(in);
        this.splitExpression = splitter;
        log.debug("Split expression is: {}", (Object)this.splitExpression);
        this.reader = new BufferedReader(new InputStreamReader(in, charset));
    }

    public CsvStream(SourceURL url, String splitExp) throws Exception {
        super(url);
        this.url = url;
        this.splitExpression = splitExp;
        this.initReader();
    }

    @Parameter(name="separator", required=true, defaultValue="(;|,)")
    public void setSeparator(String separator) {
        this.splitExpression = separator;
    }

    public String getSeparator() {
        return this.splitExpression;
    }

    public String removeQuotes(String str) {
        String s = str;
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    @Override
    public void readHeader() throws Exception {
        String[] tok;
        log.debug("Reading header, splitExpression is '{}'", (Object)this.splitExpression);
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        if (this.keys == null || this.keys.length == 0) {
            String line = this.reader.readLine();
            log.debug("line is: {}", (Object)line);
            while (line.startsWith("#")) {
                line = line.substring(1);
            }
            tok = line.split(this.splitExpression);
            for (int i = 0; i < tok.length; ++i) {
                tok[i] = this.removeQuotes(tok[i]);
                this.attributes.put(tok[i], Double.class);
            }
        } else {
            tok = this.keys;
        }
        String data = this.reader.readLine();
        while (data.startsWith("#")) {
            data = this.reader.readLine();
        }
        this.buffer.add(data);
        String[] dt = data.split(this.splitExpression);
        for (int i = 0; i < tok.length && i < dt.length; ++i) {
            if (i >= dt.length) continue;
            if (dt[i].matches("-{0,1}\\d*\\.\\d*E{0,1}-{0,1}\\d*")) {
                this.attributes.put(tok[i], Double.class);
                continue;
            }
            this.attributes.put(tok[i], String.class);
        }
    }

    @Override
    public Data readItem(Data datum) throws Exception {
        int i;
        if (datum == null) {
            datum = DataFactory.create();
        }
        String line = this.readLine();
        while (line != null && (line.trim().isEmpty() || line.startsWith("#"))) {
            if (line.startsWith("#")) {
                String[] dt = line.substring(1).split(this.splitExpression);
                for (i = 0; i < dt.length; ++i) {
                    if (i >= dt.length) continue;
                    if (dt[i].matches("(-|\\+)?\\d*\\.\\d*")) {
                        this.attributes.put(dt[i], Double.class);
                        continue;
                    }
                    this.attributes.put(dt[i], String.class);
                }
            }
            line = this.reader.readLine();
        }
        if (line != null && !line.trim().equals("")) {
            String[] tok = line.split(this.splitExpression);
            i = 0;
            for (String name : this.attributes.keySet()) {
                if (i < tok.length) {
                    if (Double.class.equals(this.attributes.get(name))) {
                        try {
                            datum.put(name, new Double(this.removeQuotes(tok[i])));
                        }
                        catch (Exception e) {
                            datum.put(name, this.removeQuotes(tok[i]));
                        }
                    } else {
                        datum.put(name, this.removeQuotes(tok[i]));
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            return null;
        }
        return this.preprocess(datum);
    }

    public String readLine() throws Exception {
        if (this.reader == null) {
            this.initReader();
        }
        if (this.buffer != null && !this.buffer.isEmpty()) {
            return this.buffer.removeFirst();
        }
        return this.reader.readLine();
    }

    protected Data preprocess(Data datum) throws Exception {
        if (datum == null) {
            return null;
        }
        return datum;
    }

    @Override
    public void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.error("Failed to properly close reader: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }
}

