/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.io.AbstractDataStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class DirectoryStream
extends AbstractDataStream {
    Logger log = LoggerFactory.getLogger(DirectoryStream.class);
    private File dir;
    private String[] files;
    private String dirPath;
    private int counter;

    public DirectoryStream(SourceURL url) throws Exception {
        super(url);
        this.initReader();
    }

    @Override
    protected void initReader() throws Exception {
        this.dir = new File(new URI(this.url.toString()));
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Directory not found");
        }
        this.dirPath = this.dir.getAbsolutePath();
        this.files = this.dir.list();
        this.counter = 0;
    }

    @Override
    public void readHeader() throws Exception {
    }

    @Override
    public Data readItem(Data data) throws Exception {
        if (this.counter < this.files.length) {
            data.put("@url", new URL("file:" + this.dirPath + System.getProperty("file.separator") + this.files[this.counter]));
            data.put("@directory", this.dirPath);
            data.put("@filename", this.files[this.counter]);
            ++this.counter;
            return data;
        }
        return null;
    }

    @Override
    public void close() {
    }
}

