/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.AbstractDataStream;
import stream.io.SourceURL;
import stream.util.parser.Parser;
import stream.util.parser.ParserGenerator;

@Description(group="Data Stream.Sources")
public class LineStream
extends AbstractDataStream {
    static Logger log = LoggerFactory.getLogger(LineStream.class);
    String key = "LINE";
    String format = null;
    Parser<Map<String, String>> parser = null;

    public LineStream(SourceURL url) throws Exception {
        super(url);
        this.initReader();
    }

    public LineStream(SourceURL url, String username, String password) throws Exception {
        super(url, username, password);
    }

    public LineStream(InputStream in) throws Exception {
        super(in);
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(required=false, defaultValue="LINE", description="")
    public void setKey(String key) {
        this.key = key;
    }

    public String getFormat() {
        return this.format;
    }

    @Parameter(required=false, description="The format how to parse each line. Elements like %(KEY) will be detected and automatically populated in the resulting items.")
    public void setFormat(String format) {
        this.format = format;
        try {
            ParserGenerator pg = new ParserGenerator(format);
            this.parser = pg.newParser();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create parser for format: " + e.getMessage());
        }
    }

    @Override
    public void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.error("FAiled to close reader: {}", (Object)e.getMessage());
                if (!log.isTraceEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void readHeader() throws Exception {
    }

    @Override
    public Data readItem(Data instance) throws Exception {
        String line;
        if (this.limit != null && this.limit > 0L && this.count > this.limit) {
            return null;
        }
        if (instance == null) {
            instance = DataFactory.create();
        }
        if ((line = this.reader.readLine()) == null) {
            return null;
        }
        instance.put(this.key, line);
        if (this.parser != null) {
            Map<String, String> map = this.parser.parse(line);
            for (String key : map.keySet()) {
                instance.put(key, map.get(key));
            }
        }
        return instance;
    }
}

