/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.urls.TcpConnection;
import stream.util.parser.Parser;
import stream.util.parser.ParserGenerator;

public final class SourceURL
implements Serializable {
    private static final long serialVersionUID = -7992522266824113404L;
    static Logger log = LoggerFactory.getLogger(SourceURL.class);
    static final String FILE_GRAMMAR = "%(protocol):%(path)";
    static final String GRAMMAR = "%(protocol)://%(host):%(port)/%(path)";
    final URL url;
    final String urlString;
    final String protocol;
    final String host;
    final int port;
    final String path;
    final String username;
    final String password;

    public SourceURL(URL url) {
        this.url = url;
        this.urlString = url.toString();
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        this.path = url.getPath();
        this.username = null;
        this.password = null;
    }

    public SourceURL(String urlString) throws Exception {
        this.url = null;
        this.urlString = urlString;
        if (urlString.toLowerCase().startsWith("file:") || urlString.toLowerCase().startsWith("classpath")) {
            ParserGenerator gen = new ParserGenerator(FILE_GRAMMAR);
            Parser<Map<String, String>> parser = gen.newParser();
            Map<String, String> vals = parser.parse(urlString);
            this.protocol = vals.get("protocol");
            this.host = null;
            this.username = null;
            this.password = null;
            this.port = -1;
            this.path = vals.get("path");
        } else {
            ParserGenerator gen = new ParserGenerator(GRAMMAR);
            Parser<Map<String, String>> parser = gen.newParser();
            Map<String, String> vals = parser.parse(urlString);
            this.protocol = vals.get("protocol");
            String hostname = vals.get("host");
            int at = hostname.indexOf("@");
            if (at >= 0) {
                String auth = hostname.substring(0, at);
                String[] tok = auth.split(":", 2);
                if (tok.length > 1) {
                    this.username = tok[0];
                    this.password = tok[1];
                } else {
                    this.username = auth;
                    this.password = "";
                }
                this.host = hostname.substring(at + 1);
            } else {
                this.host = hostname;
                this.username = null;
                this.password = null;
            }
            this.port = vals.get("port") == null || "".equals(vals.get("port").trim()) ? -1 : new Integer(vals.get("port"));
            this.path = vals.get("path");
        }
    }

    public InputStream openStream() throws IOException {
        if (this.url != null) {
            return this.url.openStream();
        }
        if ("classpath".equalsIgnoreCase(this.protocol)) {
            log.debug("Returning InputStream for classpath resource '{}'", (Object)this.getPath());
            if (this.urlString.toLowerCase().endsWith(".gz")) {
                log.debug("Opening URL {} as GZIP stream...", (Object)this.urlString);
                return new GZIPInputStream(SourceURL.class.getResourceAsStream(this.getPath()));
            }
            return SourceURL.class.getResourceAsStream(this.getPath());
        }
        if ("tcp".equalsIgnoreCase(this.protocol)) {
            TcpConnection con = new TcpConnection(this.host, this.port);
            return con.getInputStream();
        }
        try {
            URL url = new URL(this.urlString);
            if (this.urlString.toLowerCase().endsWith(".gz")) {
                log.debug("Opening URL {} as GZIP stream...", (Object)this.urlString);
                return new GZIPInputStream(url.openStream());
            }
            return url.openStream();
        }
        catch (Exception e) {
            log.error("Failed to open '{}' with default Java URL mechanism: {}", (Object)this.urlString, (Object)e.getMessage());
            throw new IOException("No handler found for protocol '" + this.protocol + "'!");
        }
    }

    public String getFile() {
        return this.path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }
}

