/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.data.DataUtils;
import stream.data.vector.InputVector;
import stream.io.AbstractDataStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class SvmLightStream
extends AbstractDataStream {
    static Logger log = LoggerFactory.getLogger(SvmLightStream.class);
    long lineNumber = 0L;
    boolean addSparseVector = true;
    String sparseKey = null;

    public SvmLightStream(String url) throws Exception {
        this(new SourceURL(url), "@sparse-vector");
    }

    public SvmLightStream(SourceURL url) throws Exception {
        super(url);
        this.initReader();
    }

    public SvmLightStream(SourceURL url, String sparseVectorKey) throws Exception {
        this(url);
        this.setSparseKey(sparseVectorKey);
    }

    public SvmLightStream(InputStream in) throws Exception {
        super(in);
    }

    public String getSparseKey() {
        return this.sparseKey;
    }

    public void setSparseKey(String sparseKey) {
        this.sparseKey = sparseKey == null ? null : sparseKey;
    }

    @Override
    public void readHeader() throws Exception {
    }

    @Override
    public Data readItem(Data item) throws Exception {
        String line;
        if (item == null) {
            item = DataFactory.create();
        }
        if (this.limit > 0L && this.lineNumber > this.limit) {
            return null;
        }
        if (this.reader == null) {
            this.initReader();
        }
        if ((line = this.reader.readLine()) == null) {
            return null;
        }
        log.debug("line[{}]: {}", (Object)this.lineNumber, (Object)line);
        while (line != null && !line.matches("^(-|\\+)?\\d(\\.\\d+)?\\s.*")) {
            line = this.reader.readLine();
        }
        if (line == null) {
            return null;
        }
        ++this.lineNumber;
        Data datum = SvmLightStream.parseLine(item, line);
        if (this.sparseKey != null) {
            log.debug("Adding sparse vector as key '{}'", (Object)this.sparseKey);
            datum.put(this.sparseKey, SvmLightStream.readSparseVector(line));
        } else {
            log.debug("No sparse key defined, not creating sparse vector!");
        }
        return datum;
    }

    public Data readSparseVector(Data item) throws Exception {
        String line;
        if (this.reader == null) {
            this.initReader();
        }
        if ((line = this.reader.readLine()) == null) {
            return null;
        }
        log.debug("line[{}]: {}", (Object)this.lineNumber, (Object)line);
        ++this.lineNumber;
        InputVector sp = SvmLightStream.readSparseVector(line);
        item.put(this.sparseKey, sp);
        return item;
    }

    public static Data parseLine(Data item, String line, String sparseKey) throws Exception {
        int info = line.indexOf("#");
        if (info > 0) {
            line = line.substring(0, info);
        }
        String[] token = line.split("\\s+");
        item.put("@label", new Double(token[0]));
        for (int i = 1; i < token.length; ++i) {
            String[] iv = token[i].split(":");
            if (iv.length != 2) {
                log.error("Failed to split token '{}' in line: ", (Object)token[i], (Object)line);
                return null;
            }
            item.put(iv[0], new Double(iv[1]));
        }
        if (sparseKey != null) {
            HashMap<Integer, Double> pairs = new HashMap<Integer, Double>();
            for (int i = 1; i < token.length; ++i) {
                String[] iv = token[i].split(":");
                if (iv.length != 2) {
                    log.error("Failed to split token '{}' in line: ", (Object)token[i], (Object)line);
                    return null;
                }
                pairs.put(Integer.parseInt(iv[0]), Double.parseDouble(iv[1]));
            }
            item.put(sparseKey, new InputVector(pairs, false, Double.parseDouble(token[0])));
        }
        return item;
    }

    public static Data parseLine(Data item, String line) throws Exception {
        return SvmLightStream.parseLine(item, line, null);
    }

    public static InputVector readSparseVector(String line) throws Exception {
        int info = line.indexOf("#");
        if (info > 0) {
            line = line.substring(0, info);
        }
        String[] token = line.split("\\s+");
        HashMap<Integer, Double> pairs = new HashMap<Integer, Double>();
        for (int i = 1; i < token.length; ++i) {
            String[] iv = token[i].split(":");
            if (iv.length != 2) {
                log.error("Failed to split token '{}' in line: ", (Object)token[i], (Object)line);
                return null;
            }
            pairs.put(Integer.parseInt(iv[0]), Double.parseDouble(iv[1]));
        }
        return new InputVector(pairs, false, Double.parseDouble(token[0]));
    }

    public static InputVector createSparseVector(Data datum) {
        if (datum.containsKey(".sparse-vector")) {
            log.trace("Found existing sparse-vector object!");
            return (InputVector)datum.get(".sparse-vector");
        }
        for (Serializable val : datum.values()) {
            if (!(val instanceof InputVector)) continue;
            log.trace("Found existing sparse-vector object!");
            return (InputVector)val;
        }
        TreeSet<String> indexes = new TreeSet<String>();
        for (String key : datum.keySet()) {
            Serializable val = (Serializable)datum.get(key);
            if (!DataUtils.isAnnotation(key) && key.matches("\\d+") && val instanceof Double) {
                log.debug("Found numeric feature {}", (Object)key);
                indexes.add(key);
                continue;
            }
            log.debug("Skipping non-numeric feature {} of type {}", (Object)key, (Object)val.getClass());
        }
        double y = Double.NaN;
        if (datum.containsKey("@label")) {
            try {
                y = (Double)datum.get("@label");
            }
            catch (Exception e) {
                y = Double.NaN;
            }
        }
        HashMap<Integer, Double> pairs = new HashMap<Integer, Double>();
        for (String key : indexes) {
            pairs.put(Integer.parseInt(key), (Double)datum.get(key));
        }
        InputVector vec = new InputVector(pairs, false, y);
        log.trace("SparseVector: {}", (Object)vec);
        return vec;
    }

    @Override
    public void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.error("Failed to properly close reader: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }
}

